/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.flags;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.flags.MapTagBasedFlagTracker;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SavableMapFlagTracker
extends MapTagBasedFlagTracker {
    public HashMap<StringHolder, SaveOptimizedFlag> map;
    public boolean modified;
    public static AsciiMatcher valueEscapeNeededMatcher = new AsciiMatcher("\u0000\n\\");
    public static AsciiMatcher keyEscapeNeededMatcher = new AsciiMatcher("\u0000:\n\\");

    public SavableMapFlagTracker() {
        this.map = new HashMap();
    }

    public SavableMapFlagTracker(String input) {
        input = input.replace("\r", "");
        this.map = new HashMap(input.length() / 50);
        int eol = input.indexOf(10);
        int startOfLine = 0;
        while (eol != -1) {
            int colon = input.indexOf(58, startOfLine);
            if (colon != -1) {
                String key = input.substring(startOfLine, colon);
                boolean expirable = key.startsWith("\\ex");
                if (expirable) {
                    key = key.substring("\\ex".length());
                }
                key = SavableMapFlagTracker.unescapeKey(key);
                String value = SavableMapFlagTracker.unescapeValue(input.substring(colon + 1, eol));
                SaveOptimizedFlag flag = new SaveOptimizedFlag();
                flag.canExpire = expirable;
                flag.string = value;
                this.map.put(new StringHolder(key), flag);
                if (CoreConfiguration.debugVerbose) {
                    Debug.log("Verbose: MapFlagTracker, loading flag " + key + " as " + value);
                }
            }
            startOfLine = eol + 1;
            eol = input.indexOf(10, eol + 1);
        }
    }

    @Override
    public void doTotalClean() {
        if (CoreConfiguration.debugVerbose) {
            Debug.echoError("Verbose - savable tracker is beginning doTotalClean");
        }
        ArrayList<StringHolder> toRemove = new ArrayList<StringHolder>();
        for (Map.Entry<StringHolder, SaveOptimizedFlag> entry : this.map.entrySet()) {
            ObjectTag subValue;
            SaveOptimizedFlag val = entry.getValue();
            if (!val.canExpire) continue;
            TimeTag expireTime = null;
            boolean hasSubMap = false;
            if (val.map != null) {
                expireTime = (TimeTag)val.map.getObject(expirationString);
                hasSubMap = val.map.getObject(valueString).canBeType(MapTag.class);
            } else if (val.string.startsWith("map@")) {
                ObjectTag time;
                MapTag quickMap = MapTag.valueOf(val.string, CoreUtilities.noDebugContext, false);
                if (CoreConfiguration.debugVerbose) {
                    Debug.log("Verbose: MapFlagTracker, quickMap = " + quickMap.debuggable());
                }
                if ((time = quickMap.getObject(expirationString)) != null) {
                    expireTime = TimeTag.valueOf(time.toString(), CoreUtilities.noDebugContext);
                }
                hasSubMap = quickMap.getObject(valueString).canBeType(MapTag.class);
            }
            if (SavableMapFlagTracker.isExpired(expireTime)) {
                toRemove.add(entry.getKey());
                this.modified = true;
                continue;
            }
            if (!hasSubMap || !((subValue = val.getMap().getObject(valueString)) instanceof MapTag) || !this.doClean((MapTag)subValue)) continue;
            val.string = null;
            this.modified = true;
        }
        if (CoreConfiguration.debugVerbose) {
            Debug.echoError("Verbose - savable tracker has finished doTotalClean and will remove " + toRemove.size());
        }
        for (StringHolder str : toRemove) {
            this.map.remove(str);
        }
    }

    @Override
    public MapTag getRootMap(String key) {
        SaveOptimizedFlag flag = this.map.get(new StringHolder(key));
        if (flag == null) {
            return null;
        }
        return flag.getMap();
    }

    @Override
    public void setRootMap(String key, MapTag value) {
        this.modified = true;
        if (value == null) {
            this.map.remove(new StringHolder(key));
            return;
        }
        SaveOptimizedFlag flag = new SaveOptimizedFlag();
        flag.map = value;
        flag.string = null;
        if (value.containsKey(expirationString) || value.getObject(valueString) instanceof MapTag) {
            flag.canExpire = true;
        }
        this.map.put(new StringHolder(key), flag);
    }

    @Override
    public Collection<String> listAllFlags() {
        ArrayList<String> keys = new ArrayList<String>(this.map.size());
        for (StringHolder string : this.map.keySet()) {
            keys.add(string.str);
        }
        return keys;
    }

    public static String unescapeValue(String key) {
        if (!CoreUtilities.contains(key, '\\')) {
            return key;
        }
        key = CoreUtilities.replace(key, "\\nl", "\n");
        key = CoreUtilities.replace(key, "\\bs", "\\");
        return key;
    }

    public static String escapeValue(String key) {
        if (!valueEscapeNeededMatcher.containsAnyMatch(key)) {
            return key;
        }
        key = CoreUtilities.replace(key, "\\", "\\bs");
        key = CoreUtilities.replace(key, "\n", "\\nl");
        key = CoreUtilities.replace(key, "\u0000", "");
        return key;
    }

    public static String unescapeKey(String key) {
        if (!CoreUtilities.contains(key, '\\')) {
            return key;
        }
        key = CoreUtilities.replace(key, "\\co", ":");
        key = CoreUtilities.replace(key, "\\nl", "\n");
        key = CoreUtilities.replace(key, "\\bs", "\\");
        return key;
    }

    public static String escapeKey(String key) {
        if (!keyEscapeNeededMatcher.containsAnyMatch(key)) {
            return key;
        }
        key = CoreUtilities.replace(key, "\\", "\\bs");
        key = CoreUtilities.replace(key, ":", "\\co");
        key = CoreUtilities.replace(key, "\n", "\\nl");
        key = CoreUtilities.replace(key, "\u0000", "");
        return key;
    }

    public String toString() {
        StringBuilder toOutput = new StringBuilder(this.map.size() * 100);
        for (Map.Entry<StringHolder, SaveOptimizedFlag> flag : this.map.entrySet()) {
            if (flag.getValue().canExpire) {
                toOutput.append("\\ex");
            }
            toOutput.append(SavableMapFlagTracker.escapeKey(flag.getKey().str)).append(":").append(SavableMapFlagTracker.escapeValue(flag.getValue().getString())).append('\n');
        }
        return toOutput.toString();
    }

    public static SavableMapFlagTracker loadFlagFile(String filePath, boolean doClean) {
        if (CoreConfiguration.debugVerbose) {
            Debug.echoError("Verbose - loading flag file path at " + filePath);
        }
        String content = CoreUtilities.journallingLoadFile(filePath + ".dat");
        if (CoreConfiguration.debugVerbose) {
            Debug.echoError("Verbose - loaded flag content for " + filePath + " as " + String.valueOf(content == null ? "null" : Integer.valueOf(content.length())));
        }
        if (content == null) {
            return new SavableMapFlagTracker();
        }
        SavableMapFlagTracker tracker = new SavableMapFlagTracker(content);
        if (CoreConfiguration.debugVerbose) {
            Debug.echoError("Verbose - loading flag file path at " + filePath + " to tracker of " + tracker.map.size() + " flags... doClean=" + doClean);
        }
        if (doClean && !CoreConfiguration.skipAllFlagCleanings) {
            tracker.doTotalClean();
        }
        return tracker;
    }

    public void saveToFile(String filePath) {
        this.saveToFile(filePath, true);
    }

    public void saveToFile(String filePath, boolean lockUntilDone) {
        String data = this.toString();
        Runnable run = () -> CoreUtilities.journallingFileSave(filePath + ".dat", data);
        if (lockUntilDone) {
            run.run();
        } else {
            DenizenCore.runAsync(run);
        }
    }

    public static class SaveOptimizedFlag {
        public MapTag map;
        public String string;
        public boolean canExpire;

        public MapTag getMap() {
            if (this.map == null) {
                if (this.string.startsWith("map@")) {
                    this.map = MapTag.valueOf(this.string, CoreUtilities.noDebugContext);
                } else {
                    this.map = new MapTag();
                    this.map.putObject(MapTagBasedFlagTracker.valueString, ObjectFetcher.pickObjectFor(this.string, CoreUtilities.noDebugContext));
                }
            }
            return this.map;
        }

        public String getString() {
            if (this.string == null) {
                this.string = this.map.containsKey(MapTagBasedFlagTracker.expirationString) || this.map.getObject(MapTagBasedFlagTracker.valueString) instanceof MapTag ? this.map.savable() : this.map.getObject(MapTagBasedFlagTracker.valueString).savable();
            }
            return this.string;
        }
    }
}

