/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import net.citizensnpcs.api.npc.NPC;

public class VulnerableCommand
extends AbstractCommand {
    public VulnerableCommand() {
        this.setName("vulnerable");
        this.setSyntax("vulnerable (state:{true}/false/toggle)");
        this.setRequiredArguments(0, 1);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Toggle.class)) {
                scriptEntry.addObject("action", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("action", new ElementTag("toggle"));
        if (!Utilities.entryHasNPC(scriptEntry)) {
            throw new InvalidArgumentsException("This command requires a linked NPC!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag action = scriptEntry.getElement("action");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), Utilities.getEntryNPC(scriptEntry), action);
        }
        NPC npc = Utilities.getEntryNPC(scriptEntry).getCitizen();
        Toggle toggle = Toggle.valueOf(action.asString().toUpperCase());
        npc.setProtected(!(toggle != Toggle.TOGGLE ? action.asBoolean() : npc.isProtected()));
    }

    static enum Toggle {
        TRUE,
        FALSE,
        TOGGLE;

    }
}

