/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;

public class EntityPicksUpItemScriptEvent
extends BukkitScriptEvent
implements Listener {
    public ItemTag item;
    public EntityTag entity;
    public EntityPickupItemEvent event;
    private static final Set<UUID> editedItems = new HashSet<UUID>();

    public EntityPicksUpItemScriptEvent() {
        this.registerCouldMatcher("<entity> picks up <item>");
        this.registerCouldMatcher("<entity> takes <item>");
        this.registerDetermination("item", ItemTag.class, (evt, context, item) -> {
            editedItems.add(this.event.getItem().getUniqueId());
            evt.event.getItem().setItemStack(item.getItemStack());
            evt.event.setCancelled(true);
        });
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryArgObject(0, this.entity)) {
            return false;
        }
        if (!path.tryArgObject(path.eventArgLowerAt(1).equals("picks") ? 3 : 2, this.item)) {
            return false;
        }
        if (!this.runInCheck(path, this.event.getItem().getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "item" -> this.item;
            case "entity" -> new EntityTag((Entity)this.event.getItem());
            case "pickup_entity" -> this.entity.getDenizenObject();
            case "location" -> new LocationTag(this.event.getItem().getLocation());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onEntityPicksUpItem(EntityPickupItemEvent event) {
        if (editedItems.remove(event.getItem().getUniqueId())) {
            return;
        }
        this.entity = new EntityTag((Entity)event.getEntity());
        this.item = new ItemTag(event.getItem().getItemStack());
        this.event = event;
        this.fire((Event)event);
    }
}

