/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.TradeTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.TagContext;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.VillagerReplenishTradeEvent;

public class VillagerReplenishesTradeScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityTag entity;
    public VillagerReplenishTradeEvent event;

    public VillagerReplenishesTradeScriptEvent() {
        this.registerCouldMatcher("villager replenishes trade");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        ElementTag element;
        if (TradeTag.matches(determinationObj.toString())) {
            this.event.setRecipe(determinationObj.asType(TradeTag.class, (TagContext)this.getTagContext(path)).getRecipe());
            return true;
        }
        if (determinationObj instanceof ElementTag && (element = (ElementTag)determinationObj).isInt()) {
            this.event.setBonus(element.asInt());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "entity": {
                return this.entity;
            }
            case "trade": {
                return new TradeTag(this.event.getRecipe()).duplicate();
            }
            case "bonus": {
                return new ElementTag(this.event.getBonus());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onVillagerReplenishesTrade(VillagerReplenishTradeEvent event) {
        this.event = event;
        this.entity = new EntityTag((Entity)event.getEntity());
        this.fire((Event)event);
    }
}

