/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.properties;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.SkinParts;
import java.util.Collection;
import net.kyori.adventure.util.TriState;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class PaperPlayerExtensions {
    public static void register() {
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, (String)"affects_monster_spawning", (attribute, object) -> new ElementTag(object.getPlayerEntity().getAffectsSpawning()), (String[])new String[0]);
        PlayerTag.registerOnlineOnlyTag(MapTag.class, (String)"client_options", (attribute, object) -> {
            MapTag map = new MapTag();
            Player player = object.getPlayerEntity();
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19)) {
                map.putObject("allow_server_listings", (ObjectTag)new ElementTag(((Boolean)player.getClientOption(ClientOption.ALLOW_SERVER_LISTINGS)).booleanValue()));
                map.putObject("text_filtering_enabled", (ObjectTag)new ElementTag(((Boolean)player.getClientOption(ClientOption.TEXT_FILTERING_ENABLED)).booleanValue()));
            }
            map.putObject("chat_colors_enabled", (ObjectTag)new ElementTag(((Boolean)player.getClientOption(ClientOption.CHAT_COLORS_ENABLED)).booleanValue()));
            map.putObject("chat_visibility", (ObjectTag)new ElementTag((Enum)player.getClientOption(ClientOption.CHAT_VISIBILITY)));
            map.putObject("locale", (ObjectTag)new ElementTag((String)player.getClientOption(ClientOption.LOCALE)));
            map.putObject("main_hand", (ObjectTag)new ElementTag((Enum)player.getClientOption(ClientOption.MAIN_HAND)));
            MapTag skinParts = new MapTag();
            SkinParts parts = (SkinParts)player.getClientOption(ClientOption.SKIN_PARTS);
            skinParts.putObject("cape", (ObjectTag)new ElementTag(parts.hasCapeEnabled()));
            skinParts.putObject("hat", (ObjectTag)new ElementTag(parts.hasHatsEnabled()));
            skinParts.putObject("jacket", (ObjectTag)new ElementTag(parts.hasJacketEnabled()));
            skinParts.putObject("left_sleeve", (ObjectTag)new ElementTag(parts.hasLeftSleeveEnabled()));
            skinParts.putObject("right_sleeve", (ObjectTag)new ElementTag(parts.hasRightSleeveEnabled()));
            skinParts.putObject("left_pants", (ObjectTag)new ElementTag(parts.hasLeftPantsEnabled()));
            skinParts.putObject("right_pants", (ObjectTag)new ElementTag(parts.hasRightPantsEnabled()));
            map.putObject("skin_parts", (ObjectTag)skinParts);
            map.putObject("view_distance", (ObjectTag)new ElementTag(((Integer)player.getClientOption(ClientOption.VIEW_DISTANCE)).intValue()));
            return map;
        }, (String[])new String[0]);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, (String)"view_distance", (attribute, object) -> new ElementTag(object.getPlayerEntity().getViewDistance()), (String[])new String[0]);
        PlayerTag.registerOnlineOnlyMechanism((String)"affects_monster_spawning", ElementTag.class, (object, mechanism, input) -> {
            if (mechanism.requireBoolean()) {
                object.getPlayerEntity().setAffectsSpawning(input.asBoolean());
            }
        });
        PlayerTag.registerOnlineOnlyMechanism((String)"firework_boost", ItemTag.class, (object, mechanism, input) -> {
            if (!object.getPlayerEntity().isGliding()) {
                mechanism.echoError("Cannot adjust 'firework_boost': player must be gliding.");
                return;
            }
            if (input.getBukkitMaterial() != Material.FIREWORK_ROCKET) {
                mechanism.echoError("Invalid input item '" + String.valueOf(input) + "': must be a firework rocket.");
                return;
            }
            object.getPlayerEntity().boostElytra(input.getItemStack());
        });
        PlayerTag.registerOnlineOnlyMechanism((String)"fake_op_level", ElementTag.class, (object, mechanism, input) -> {
            if (mechanism.requireInteger()) {
                object.getPlayerEntity().sendOpLevel((byte)input.asInt());
            }
        });
        PlayerTag.registerOnlineOnlyMechanism((String)"view_distance", (object, mechanism) -> {
            if (!mechanism.hasValue()) {
                object.getPlayerEntity().setViewDistance(-1);
            } else if (mechanism.requireInteger()) {
                int distance = mechanism.getValue().asInt();
                if (distance < 2 || distance > 32) {
                    mechanism.echoError("Invalid view distance '" + distance + "': must be between 2 and 32.");
                    return;
                }
                object.getPlayerEntity().setViewDistance(distance);
            }
        });
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19)) {
            PlayerTag.registerOnlineOnlyTag(ElementTag.class, (String)"flying_fall_damage", (attribute, object) -> new ElementTag(object.getPlayerEntity().hasFlyingFallDamage().toBooleanOrElse(false)), (String[])new String[0]);
            PlayerTag.registerOnlineOnlyMechanism((String)"add_tab_completions", ListTag.class, (object, mechanism, input) -> object.getPlayerEntity().addAdditionalChatCompletions((Collection)input));
            PlayerTag.registerOnlineOnlyMechanism((String)"remove_tab_completions", ListTag.class, (object, mechanism, input) -> object.getPlayerEntity().removeAdditionalChatCompletions((Collection)input));
            PlayerTag.registerOnlineOnlyMechanism((String)"flying_fall_damage", ElementTag.class, (object, mechanism, input) -> {
                if (mechanism.requireBoolean()) {
                    object.getPlayerEntity().setFlyingFallDamage(TriState.byBoolean((boolean)input.asBoolean()));
                }
            });
        }
    }
}

