/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.impl.network.handlers.packet;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.v1_21.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_21.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.player.DisguiseCommand;
import com.denizenscript.denizen.utilities.entity.EntityAttachmentHelper;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.ToIntFunction;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;

public class DisguisePacketHandlers {
    private static boolean antiDuplicate = false;

    public static void registerHandlers() {
        DisguisePacketHandlers.registerPacketHandler(agf.class, agf::b, DisguisePacketHandlers::processEntityDataPacket);
        DisguisePacketHandlers.registerPacketHandler(ahk.class, ahk::b, DisguisePacketHandlers::processAttributesPacket);
        DisguisePacketHandlers.registerPacketHandler(acs.class, acs::b, DisguisePacketHandlers::sendDisguiseForPacket);
        DisguisePacketHandlers.registerPacketHandler(ahe.class, ahe::b, DisguisePacketHandlers::processTeleportPacket);
        DisguisePacketHandlers.registerPacketHandler(aeq.c.class, aeq::a, DisguisePacketHandlers::processMoveEntityRotPacket);
        DisguisePacketHandlers.registerPacketHandler(aeq.b.class, aeq::a, DisguisePacketHandlers::processMoveEntityPosRotPacket);
    }

    public static <T extends aao<acr>> void registerPacketHandler(Class<T> packetType, ToIntFunction<T> idGetter, DisguisePacketHandler<T> handler) {
        DisguisePacketHandlers.registerPacketHandler(packetType, (T packet, drq level) -> level.a(idGetter.applyAsInt(packet)), handler);
    }

    public static <T extends aao<acr>> void registerPacketHandler(Class<T> packetType, BiFunction<T, drq, cdv> entityGetter, DisguisePacketHandler<T> handler) {
        DenizenNetworkManagerImpl.registerPacketHandler(packetType, (networkManager, packet) -> {
            if (DisguiseCommand.disguises.isEmpty() || antiDuplicate) {
                return packet;
            }
            cdv entity = (cdv)entityGetter.apply((Object)packet, (drq)networkManager.player.A());
            if (entity == null) {
                return packet;
            }
            Map playerMap = (Map)DisguiseCommand.disguises.get(entity.cT());
            if (playerMap == null) {
                return packet;
            }
            DisguiseCommand.TrackedDisguise disguise = (DisguiseCommand.TrackedDisguise)playerMap.get(networkManager.player.cT());
            if (disguise == null) {
                disguise = (DisguiseCommand.TrackedDisguise)playerMap.get(null);
            }
            if (disguise == null || !disguise.isActive) {
                return packet;
            }
            if (NMSHandler.debugPackets) {
                DenizenNetworkManagerImpl.doPacketOutput("DISGUISED packet " + packet.getClass().getName() + " for entity " + entity.az() + " to player " + networkManager.player.cV());
            }
            try {
                return handler.handle(networkManager, packet, disguise);
            }
            catch (Exception e2) {
                antiDuplicate = false;
                throw e2;
            }
        });
    }

    public static agf processEntityDataPacket(DenizenNetworkManagerImpl networkManager, agf entityDataPacket, DisguiseCommand.TrackedDisguise disguise) {
        if (entityDataPacket.b() == networkManager.player.az()) {
            if (!disguise.shouldFake) {
                return entityDataPacket;
            }
            for (alq.c dataValue : entityDataPacket.e()) {
                if (dataValue.a() != 0) continue;
                ArrayList<alq.c<Byte>> newData = new ArrayList<alq.c<Byte>>(entityDataPacket.e());
                newData.remove(dataValue);
                byte flags = (Byte)dataValue.c();
                flags = (byte)(flags | 0x20);
                newData.add(PacketHelperImpl.createEntityData(PacketHelperImpl.ENTITY_DATA_ACCESSOR_FLAGS, flags));
                return new agf(entityDataPacket.b(), newData);
            }
        } else {
            List data = ((CraftEntity)disguise.toOthers.entity.entity).getHandle().aC().c();
            return data != null ? new agf(entityDataPacket.b(), data) : null;
        }
        return entityDataPacket;
    }

    public static ahk processAttributesPacket(DenizenNetworkManagerImpl networkManager, ahk attributesPacket, DisguiseCommand.TrackedDisguise disguise) {
        FakeEntity fake = attributesPacket.b() == networkManager.player.az() ? disguise.fakeToSelf : disguise.toOthers;
        return fake == null || fake.entity.entity instanceof LivingEntity ? attributesPacket : null;
    }

    public static ahe processTeleportPacket(DenizenNetworkManagerImpl networkManager, ahe teleportEntityPacket, DisguiseCommand.TrackedDisguise disguise) throws IllegalAccessException {
        if (disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
            cfj oldChange = teleportEntityPacket.e();
            return new ahe(teleportEntityPacket.b(), new cfj(oldChange.a(), oldChange.b(), EntityAttachmentHelper.normalizeAngle((float)(oldChange.c() + 180.0f)), oldChange.d()), teleportEntityPacket.f(), teleportEntityPacket.g());
        }
        return DisguisePacketHandlers.sendDisguiseForPacket(networkManager, teleportEntityPacket, disguise);
    }

    public static aeq.c processMoveEntityRotPacket(DenizenNetworkManagerImpl networkManager, aeq.c rotPacket, DisguiseCommand.TrackedDisguise disguise) {
        if (disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
            return new aeq.c(disguise.entity.getBukkitEntity().getEntityId(), EntityAttachmentHelper.compressAngle((float)(rotPacket.g() + 180.0f)), bfh.g((float)rotPacket.h()), rotPacket.k());
        }
        return DisguisePacketHandlers.sendDisguiseForPacket(networkManager, rotPacket, disguise);
    }

    public static aeq.b processMoveEntityPosRotPacket(DenizenNetworkManagerImpl networkManager, aeq.b posRotPacket, DisguiseCommand.TrackedDisguise disguise) {
        if (disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
            return new aeq.b(disguise.entity.getBukkitEntity().getEntityId(), posRotPacket.b(), posRotPacket.e(), posRotPacket.f(), EntityAttachmentHelper.compressAngle((float)(posRotPacket.g() + 180.0f)), bfh.g((float)posRotPacket.h()), posRotPacket.k());
        }
        return DisguisePacketHandlers.sendDisguiseForPacket(networkManager, posRotPacket, disguise);
    }

    public static <T extends aao<acr>> T sendDisguiseForPacket(DenizenNetworkManagerImpl networkManager, T packet, DisguiseCommand.TrackedDisguise disguise) {
        antiDuplicate = true;
        disguise.sendTo(List.of(new PlayerTag(networkManager.player.cT())));
        antiDuplicate = false;
        return null;
    }

    @FunctionalInterface
    public static interface DisguisePacketHandler<T extends aao<acr>> {
        public T handle(DenizenNetworkManagerImpl var1, T var2, DisguiseCommand.TrackedDisguise var3) throws Exception;
    }
}

