/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Goat;

public class EntityHorns
implements Property {
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntity() instanceof Goat;
    }

    public static EntityHorns getFrom(ObjectTag entity) {
        if (!EntityHorns.describes(entity)) {
            return null;
        }
        return new EntityHorns((EntityTag)entity);
    }

    public EntityHorns(EntityTag entity) {
        this.entity = entity;
    }

    @Override
    public String getPropertyString() {
        return this.getHornsList().identify();
    }

    @Override
    public String getPropertyId() {
        return "horns";
    }

    public ListTag getHornsList() {
        ListTag result = new ListTag();
        if (this.getGoat().hasLeftHorn()) {
            result.addObject(new ElementTag("left"));
        }
        if (this.getGoat().hasRightHorn()) {
            result.addObject(new ElementTag("right"));
        }
        return result;
    }

    public static void register() {
        PropertyParser.registerTag(EntityHorns.class, ListTag.class, "horns", (attribute, object) -> object.getHornsList(), new String[0]);
        PropertyParser.registerMechanism(EntityHorns.class, ListTag.class, "horns", (object, mechanism, input) -> {
            boolean left = false;
            boolean right = false;
            for (String value : input) {
                String low = CoreUtilities.toLowerCase(value);
                if (low.equals("left")) {
                    left = true;
                    continue;
                }
                if (low.equals("right")) {
                    right = true;
                    continue;
                }
                mechanism.echoError("Invalid horn '" + value + "': must be 'left' or 'right'.");
            }
            object.getGoat().setLeftHorn(left);
            object.getGoat().setRightHorn(right);
        }, new String[0]);
    }

    public Goat getGoat() {
        return (Goat)this.entity.getBukkitEntity();
    }
}

