/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.TradeTag;
import com.denizenscript.denizen.utilities.PaperAPITools;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantRecipe;

public class OpenTradesCommand
extends AbstractCommand {
    public OpenTradesCommand() {
        this.setName("opentrades");
        this.setSyntax("opentrades [<entity>/<trade>|...] (title:<title>) (players:<player>|...)");
        this.setRequiredArguments(1, 3);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("trades") && !scriptEntry.hasObject("entity") && arg.matchesArgumentList(TradeTag.class)) {
                scriptEntry.addObject("trades", arg.asType(ListTag.class).filter(TradeTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("trades") && !scriptEntry.hasObject("entity") && arg.matchesArgumentType(EntityTag.class)) {
                scriptEntry.addObject("entity", arg.asType(EntityTag.class));
                continue;
            }
            if (arg.matchesPrefix("title")) {
                scriptEntry.addObject("title", arg.asElement());
                continue;
            }
            if (arg.matchesPrefix("players") && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("players", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("trades") && !scriptEntry.hasObject("entity")) {
            throw new InvalidArgumentsException("Must specify a villager entity or a list of trades for the player(s) to trade with!");
        }
        scriptEntry.defaultObject("title", new ElementTag("")).defaultObject("players", Collections.singletonList(Utilities.getEntryPlayer(scriptEntry)));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag title = scriptEntry.getElement("title");
        EntityTag entity = (EntityTag)scriptEntry.getObjectTag("entity");
        List trades = (List)scriptEntry.getObject("trades");
        List players = (List)scriptEntry.getObject("players");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), entity, OpenTradesCommand.db("trades", trades), title, OpenTradesCommand.db("players", players));
        }
        if (entity != null) {
            if (players.size() > 1) {
                Debug.echoError("No more than one player can access the same entity!");
                return;
            }
            if (entity.getBukkitEntity() instanceof Merchant) {
                PlayerTag player = (PlayerTag)players.get(0);
                if (player.isValid() && player.isOnline()) {
                    player.getPlayerEntity().openMerchant((Merchant)entity.getBukkitEntity(), true);
                } else {
                    Debug.echoError("Tried to make a nonexistent or offline player trade with a villager entity!");
                }
                return;
            }
            Debug.echoError("The specified entity isn't a merchant!");
            return;
        }
        ArrayList<MerchantRecipe> recipes = new ArrayList<MerchantRecipe>();
        for (TradeTag trade : trades) {
            recipes.add(trade.getRecipe());
        }
        for (PlayerTag player : players) {
            if (player.isValid() && player.isOnline()) {
                Merchant merchant = PaperAPITools.instance.createMerchant(title.asString());
                merchant.setRecipes(recipes);
                player.getPlayerEntity().openMerchant(merchant, true);
                continue;
            }
            Debug.echoError("Tried to make a nonexistent or offline player view a virtual trading inventory!");
        }
    }
}

