/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.inventory.Inventory;

public class BrewsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public LocationTag location;
    public BrewEvent event;

    public BrewsScriptEvent() {
        this.registerCouldMatcher("brewing stand brews");
        this.registerDetermination("result", ListTag.class, (evt, context, result) -> {
            evt.event.getResults().clear();
            for (ItemTag item : result.filter(ItemTag.class, context)) {
                evt.event.getResults().add(item.getItemStack());
            }
        });
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "location" -> this.location;
            case "inventory" -> InventoryTag.mirrorBukkitInventory((Inventory)this.event.getContents());
            case "fuel_level" -> new ElementTag(this.event.getFuelLevel());
            case "result" -> new ListTag(this.event.getResults(), ItemTag::new);
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onBrews(BrewEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

