/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EntityType;

public class EntityPowered
implements Property {
    public static final String[] handledTags = new String[]{"powered"};
    public static final String[] handledMechs = new String[]{"powered"};
    EntityTag powered;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntityType() == EntityType.CREEPER;
    }

    public static EntityPowered getFrom(ObjectTag entity) {
        if (!EntityPowered.describes(entity)) {
            return null;
        }
        return new EntityPowered((EntityTag)entity);
    }

    public EntityPowered(EntityTag entity) {
        this.powered = entity;
    }

    public boolean getPowered() {
        return ((Creeper)this.powered.getBukkitEntity()).isPowered();
    }

    public void setPowered(boolean power) {
        if (this.powered == null) {
            return;
        }
        ((Creeper)this.powered.getBukkitEntity()).setPowered(power);
    }

    @Override
    public String getPropertyString() {
        if (!this.getPowered()) {
            return null;
        }
        return "true";
    }

    @Override
    public String getPropertyId() {
        return "powered";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("powered")) {
            return new ElementTag(this.getPowered()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("powered") && mechanism.requireBoolean()) {
            this.setPowered(mechanism.getValue().asBoolean());
        }
    }
}

