/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizen.nms.interfaces.ItemHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.v1_21.Handler;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_21.helpers.NBTAdapter;
import com.denizenscript.denizen.nms.v1_21.impl.ProfileEditorImpl;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.item.ItemComponentsPatch;
import com.denizenscript.denizen.objects.properties.item.ItemRawNBT;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.PaperAPITools;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftBlastingRecipe;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftCampfireRecipe;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftFurnaceRecipe;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftShapedRecipe;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftShapelessRecipe;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftSmithingTransformRecipe;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftSmithingTrimRecipe;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftSmokingRecipe;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftStonecuttingRecipe;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftTransmuteRecipe;
import org.bukkit.craftbukkit.v1_21_R6.map.CraftMapView;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.ComplexRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingTransformRecipe;
import org.bukkit.inventory.SmithingTrimRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.inventory.TransmuteRecipe;
import org.bukkit.map.MapView;

public class ItemHelperImpl
extends ItemHelper {
    public static final Field Item_components = ReflectionHelper.getFields(dhl.class).get(ReflectionMappingsInfo.Item_components, km.class);
    public static final Field RecipeManager_featureFlagSet = ReflectionHelper.getFields(dmp.class).getFirstOfType(dcx.class);
    public Object recipeManagerFeatureFlagSetCache = null;
    public static final int DATA_VERSION_1_20_4 = 3700;
    public static final Field AdventureModePredicate_predicates = ReflectionHelper.getFields(dfq.class).get(ReflectionMappingsInfo.AdventureModePredicate_predicates);
    public static Class<?> PaperPotionMix_CLASS = null;
    public static Map<NamespacedKey, ItemHelper.BrewingRecipe> customBrewingRecipes = null;

    public static dmn<?> getNMSRecipe(NamespacedKey key) {
        ami nmsKey = ami.a((ami)mp.bD, (amj)CraftNamespacedKey.toMinecraft((NamespacedKey)key));
        return ((CraftServer)Bukkit.getServer()).getServer().aN().b(nmsKey).orElse(null);
    }

    public void setMaxStackSize(Material material, int size) {
        try {
            ReflectionHelper.getFinalSetter(Material.class, (String)"maxStack").invoke(material, size);
            dhl nmsItem = (dhl)mo.h.a(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey()));
            km currentComponents = nmsItem.f();
            Item_components.set(nmsItem, km.a((km)currentComponents, (km)km.a().a(kp.c, (Object)size).a()));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public static dmp getRecipeManager() {
        return ((CraftServer)Bukkit.getServer()).getServer().aN();
    }

    public static up serializeNmsItem(dhp nmsItem) {
        return (up)dhp.b.encodeStart((DynamicOps)CraftRegistry.getMinecraftRegistry().a((DynamicOps)vd.a), (Object)nmsItem).getOrThrow();
    }

    public static dhp parseNmsItem(up nmsTag) {
        return (dhp)dhp.b.parse((DynamicOps)CraftRegistry.getMinecraftRegistry().a((DynamicOps)vd.a), (Object)nmsTag).getOrThrow();
    }

    public void blockRecipeFinalization() {
        try {
            dmp manager = ItemHelperImpl.getRecipeManager();
            Object flags = RecipeManager_featureFlagSet.get(manager);
            if (flags != null) {
                this.recipeManagerFeatureFlagSetCache = flags;
                RecipeManager_featureFlagSet.set(manager, null);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void restoreRecipeFinalization() {
        try {
            dmp manager = ItemHelperImpl.getRecipeManager();
            if (this.recipeManagerFeatureFlagSetCache != null) {
                RecipeManager_featureFlagSet.set(manager, this.recipeManagerFeatureFlagSetCache);
                manager.finalizeRecipeLoading();
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void removeRecipes(List<NamespacedKey> keys) {
        this.blockRecipeFinalization();
        dmp manager = ItemHelperImpl.getRecipeManager();
        for (NamespacedKey key : keys) {
            ami nmsKey = ami.a((ami)mp.bD, (amj)CraftNamespacedKey.toMinecraft((NamespacedKey)key));
            manager.removeRecipe(nmsKey);
        }
        this.restoreRecipeFinalization();
    }

    public Integer burnTime(Material material) {
        return MinecraftServer.getServer().bw().b(new dhp((drp)CraftMagicNumbers.getItem((Material)material)));
    }

    public void setShapedRecipeIngredient(ShapedRecipe recipe, char c2, ItemStack[] item, boolean exact) {
        if (item.length == 1 && item[0].getType() == Material.AIR) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(Material.AIR));
        } else if (exact) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.ExactChoice(item));
        } else {
            Material[] mats = new Material[item.length];
            for (int i = 0; i < item.length; ++i) {
                mats[i] = item[i].getType();
            }
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(mats));
        }
    }

    public static dme itemArrayToRecipe(ItemStack[] items, boolean exact) {
        if (!exact) {
            return dme.a(Arrays.stream(items).map(item -> CraftMagicNumbers.getItem((Material)item.getType())));
        }
        return dme.ofStacks(Arrays.stream(items).map(CraftItemStack::asNMSCopy).toList());
    }

    public static ami<dmi<?>> createRecipeKey(String name) {
        return ami.a((ami)mp.bD, (amj)amj.a((String)"denizen", (String)name));
    }

    public void registerFurnaceRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, float exp, int time, String type, boolean exact, String category) {
        dlu categoryValue;
        ami<dmi<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        dme itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        dlu dlu2 = categoryValue = category == null ? dlu.c : dlu.valueOf((String)CoreUtilities.toUpperCase((String)category));
        Object recipe = type.equalsIgnoreCase("smoker") ? new dnh(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("blast") ? new dlr(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("campfire") ? new dlt(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : new dnc(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time)));
        dmn holder = new dmn(key, (dmi)recipe);
        ItemHelperImpl.getRecipeManager().addRecipe(holder);
    }

    public void registerStonecuttingRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, boolean exact) {
        ami<dmi<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        dme itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        dni recipe = new dni(group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result));
        dmn holder = new dmn(key, (dmi)recipe);
        ItemHelperImpl.getRecipeManager().addRecipe(holder);
    }

    public void registerSmithingRecipe(String keyName, ItemStack result, ItemStack[] baseItem, boolean baseExact, ItemStack[] upgradeItem, boolean upgradeExact, ItemStack[] templateItem, boolean templateExact) {
        ami<dmi<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        dme templateItemRecipe = ItemHelperImpl.itemArrayToRecipe(templateItem, templateExact);
        dme baseItemRecipe = ItemHelperImpl.itemArrayToRecipe(baseItem, baseExact);
        dme upgradeItemRecipe = ItemHelperImpl.itemArrayToRecipe(upgradeItem, upgradeExact);
    }

    public void registerShapelessRecipe(String keyName, String group, ItemStack result, List<ItemStack[]> ingredients, boolean[] exact, String category) {
        ami<dmi<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        ArrayList<dme> ingredientList = new ArrayList<dme>();
        dlv categoryValue = category == null ? dlv.d : dlv.valueOf((String)CoreUtilities.toUpperCase((String)category));
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredientList.add(ItemHelperImpl.itemArrayToRecipe(ingredients.get(i), exact[i]));
        }
        dmy recipe = new dmy(group, categoryValue, CraftItemStack.asNMSCopy((ItemStack)result), (List)jt.a(null, (Object[])ingredientList.toArray(new dme[0])));
        dmn holder = new dmn(key, (dmi)recipe);
        ItemHelperImpl.getRecipeManager().addRecipe(holder);
    }

    public void registerOtherRecipe(Recipe recipe) {
        CraftRecipe toAdd;
        if (recipe instanceof CraftRecipe) {
            CraftRecipe craft;
            toAdd = craft = (CraftRecipe)recipe;
        } else if (recipe instanceof ShapedRecipe) {
            toAdd = CraftShapedRecipe.fromBukkitRecipe((ShapedRecipe)((ShapedRecipe)recipe));
        } else if (recipe instanceof ShapelessRecipe) {
            toAdd = CraftShapelessRecipe.fromBukkitRecipe((ShapelessRecipe)((ShapelessRecipe)recipe));
        } else if (recipe instanceof FurnaceRecipe) {
            toAdd = CraftFurnaceRecipe.fromBukkitRecipe((FurnaceRecipe)((FurnaceRecipe)recipe));
        } else if (recipe instanceof BlastingRecipe) {
            toAdd = CraftBlastingRecipe.fromBukkitRecipe((BlastingRecipe)((BlastingRecipe)recipe));
        } else if (recipe instanceof CampfireRecipe) {
            toAdd = CraftCampfireRecipe.fromBukkitRecipe((CampfireRecipe)((CampfireRecipe)recipe));
        } else if (recipe instanceof SmokingRecipe) {
            toAdd = CraftSmokingRecipe.fromBukkitRecipe((SmokingRecipe)((SmokingRecipe)recipe));
        } else if (recipe instanceof StonecuttingRecipe) {
            toAdd = CraftStonecuttingRecipe.fromBukkitRecipe((StonecuttingRecipe)((StonecuttingRecipe)recipe));
        } else if (recipe instanceof SmithingTransformRecipe) {
            toAdd = CraftSmithingTransformRecipe.fromBukkitRecipe((SmithingTransformRecipe)((SmithingTransformRecipe)recipe));
        } else if (recipe instanceof SmithingTrimRecipe) {
            toAdd = CraftSmithingTrimRecipe.fromBukkitRecipe((SmithingTrimRecipe)((SmithingTrimRecipe)recipe));
        } else {
            if (!(recipe instanceof TransmuteRecipe)) {
                if (recipe instanceof ComplexRecipe) {
                    throw new UnsupportedOperationException("Cannot add custom complex recipe");
                }
                return;
            }
            toAdd = CraftTransmuteRecipe.fromBukkitRecipe((TransmuteRecipe)((TransmuteRecipe)recipe));
        }
        toAdd.addToCraftingManager();
    }

    public String getJsonString(ItemStack itemStack) {
        String json = CraftItemStack.asNMSCopy((ItemStack)itemStack).K().a().toString().replace("\\", "\\\\").replace("\"", "\\\"");
        return json.substring(176, json.length() - 185);
    }

    public JsonObject getRawHoverComponentsJson(ItemStack item) {
        kn nmsComponents = CraftItemStack.asNMSCopy((ItemStack)item).d();
        if (nmsComponents.d()) {
            return null;
        }
        return ((JsonElement)kn.b.encodeStart((DynamicOps)CraftRegistry.getMinecraftRegistry().a((DynamicOps)JsonOps.INSTANCE), (Object)nmsComponents).getOrThrow()).getAsJsonObject();
    }

    public ItemStack applyRawHoverComponentsJson(ItemStack item, JsonObject components) {
        return (ItemStack)kn.b.parse((DynamicOps)CraftRegistry.getMinecraftRegistry().a((DynamicOps)JsonOps.INSTANCE), (Object)components).mapOrElse(nmsComponents -> {
            dhp nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
            nmsItem.b(nmsComponents);
            return CraftItemStack.asCraftMirror((dhp)nmsItem);
        }, error -> {
            Debug.echoError((String)("Invalid hover item data '" + String.valueOf(components) + "': " + error.message()));
            return item;
        });
    }

    public PlayerProfile getSkullSkin(ItemStack is) {
        dhp itemStack = CraftItemStack.asNMSCopy((ItemStack)is);
        dkq profile = (dkq)itemStack.a(kp.ak);
        if (profile != null) {
            Property property = (Property)Iterables.getFirst((Iterable)profile.b().properties().get((Object)"textures"), null);
            return new PlayerProfile((String)profile.d().orElse(null), ProfileEditorImpl.getUUID(profile), property != null ? property.value() : null, property != null ? property.signature() : null);
        }
        return null;
    }

    public ItemStack setSkullSkin(ItemStack itemStack, PlayerProfile playerProfile) {
        GameProfile gameProfile = ProfileEditorImpl.getGameProfile(playerProfile);
        dhp nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItemStack.b(kp.ak, (Object)dkq.a((GameProfile)gameProfile));
        return CraftItemStack.asBukkitCopy((dhp)nmsItemStack);
    }

    public ItemStack addNbtData(ItemStack itemStack, String key, BinaryTag value) {
        dhp nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItemStack.a(kp.b, (Object)djy.a, customData -> customData.a(nmsCompoundTag -> nmsCompoundTag.a(key, NBTAdapter.toNMS(value))));
        return CraftItemStack.asBukkitCopy((dhp)nmsItemStack);
    }

    public CompoundBinaryTag getNbtData(ItemStack itemStack) {
        dhp nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        if (nmsItemStack != null && !nmsItemStack.f()) {
            return NBTAdapter.toAPI(ItemHelperImpl.serializeNmsItem(nmsItemStack));
        }
        return CompoundBinaryTag.empty();
    }

    public ItemStack setNbtData(ItemStack itemStack, CompoundBinaryTag compoundTag) {
        return CraftItemStack.asBukkitCopy((dhp)ItemHelperImpl.parseNmsItem(NBTAdapter.toNMS(compoundTag)));
    }

    public CompoundBinaryTag getCustomData(ItemStack item) {
        djy customData = (djy)CraftItemStack.asNMSCopy((ItemStack)item).a(kp.b);
        return customData != null ? NBTAdapter.toAPI(customData.b()) : null;
    }

    public ItemStack setCustomData(ItemStack item, CompoundBinaryTag data) {
        dhp nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        if (data == null) {
            nmsItemStack.e(kp.b);
        } else {
            nmsItemStack.b(kp.b, (Object)djy.a((up)NBTAdapter.toNMS(data)));
        }
        return CraftItemStack.asBukkitCopy((dhp)nmsItemStack);
    }

    public ItemStack setPartialOldNbt(ItemStack item, CompoundBinaryTag oldTag) {
        int currentDataVersion = CraftMagicNumbers.INSTANCE.getDataVersion();
        up nmsOldTag = new up();
        nmsOldTag.a("id", item.getType().getKey().toString());
        nmsOldTag.a("Count", (byte)item.getAmount());
        nmsOldTag.a("tag", (vp)NBTAdapter.toNMS(oldTag));
        up nmsUpdatedTag = (up)MinecraftServer.getServer().L.update(boz.v, new Dynamic((DynamicOps)vd.a, (Object)nmsOldTag), 3700, currentDataVersion).getValue();
        up nmsCurrentTag = ItemHelperImpl.serializeNmsItem(CraftItemStack.asNMSCopy((ItemStack)item));
        up nmsMergedTag = nmsCurrentTag.a(nmsUpdatedTag);
        return CraftItemStack.asBukkitCopy((dhp)ItemHelperImpl.parseNmsItem(nmsMergedTag));
    }

    public CompoundBinaryTag getEntityData(ItemStack item) {
        dkw entityData = (dkw)CraftItemStack.asNMSCopy((ItemStack)item).a(kp.Y);
        return entityData != null ? NBTAdapter.toAPI(entityData.b()) : null;
    }

    public ItemStack setEntityData(ItemStack item, CompoundBinaryTag entityNbt, EntityType entityType) {
        dhp nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        if (entityNbt == null || entityNbt.isEmpty() || entityNbt.size() == 1 && entityNbt.keySet().contains("id")) {
            nmsItemStack.e(kp.Y);
        } else {
            up nmsEntityNbt = NBTAdapter.toNMS(entityNbt);
            nmsEntityNbt.r("id");
            nmsItemStack.b(kp.Y, (Object)dkw.a((Object)CraftEntityType.bukkitToMinecraft((EntityType)entityType), (up)nmsEntityNbt));
        }
        return CraftItemStack.asBukkitCopy((dhp)nmsItemStack);
    }

    public MapTag getRawComponentsPatch(ItemStack item, boolean excludeHandled) {
        dhp nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        kn patch = nmsItemStack.d();
        if (excludeHandled) {
            patch = patch.a(componentType -> {
                amj componentId = mo.an.b(componentType);
                return ItemComponentsPatch.propertyHandledComponents.contains(componentId.toString());
            });
        }
        if (patch.d()) {
            return new MapTag();
        }
        amh registryOps = CraftRegistry.getMinecraftRegistry().a((DynamicOps)vd.a);
        up nmsPatch = (up)kn.b.encodeStart((DynamicOps)registryOps, (Object)patch).getOrThrow();
        MapTag rawComponents = (MapTag)ItemRawNBT.nbtTagToObject((BinaryTag)NBTAdapter.toAPI(nmsPatch));
        rawComponents.putObject("denizen:__data_version", (ObjectTag)new ElementTag(CraftMagicNumbers.INSTANCE.getDataVersion()));
        return rawComponents;
    }

    public ItemStack setRawComponentsPatch(ItemStack item, MapTag rawComponentsMap, int dataVersion, Consumer<String> errorHandler) {
        int currentDataVersion = CraftMagicNumbers.INSTANCE.getDataVersion();
        CompoundBinaryTag rawComponents = (CompoundBinaryTag)ItemRawNBT.convertObjectToNbt((ObjectTag)rawComponentsMap, (TagContext)CoreUtilities.errorButNoDebugContext, (String)"");
        up nmsRawComponents = NBTAdapter.toNMS(rawComponents);
        amh registryOps = CraftRegistry.getMinecraftRegistry().a((DynamicOps)vd.a);
        if (dataVersion < currentDataVersion) {
            up legacyItemData = new up();
            legacyItemData.a("id", item.getType().getKey().toString());
            legacyItemData.a("count", item.getAmount());
            legacyItemData.a("components", (vp)nmsRawComponents);
            up nmsUpdatedTag = (up)MinecraftServer.getServer().L.update(boz.v, new Dynamic((DynamicOps)registryOps, (Object)legacyItemData), dataVersion, currentDataVersion).getValue();
            nmsRawComponents = nmsUpdatedTag.m("components").orElseGet(up::new);
        }
        dhp nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        kn.b.parse((DynamicOps)registryOps, (Object)nmsRawComponents).ifError(error -> errorHandler.accept(error.message())).ifSuccess(arg_0 -> ((dhp)nmsItemStack).b(arg_0));
        return CraftItemStack.asBukkitCopy((dhp)nmsItemStack);
    }

    public List<Material> getCanPlaceOn(ItemStack item) {
        return this.getAdventureModePredicateMaterials(item, (ko<dfq>)kp.m);
    }

    public ItemStack setCanPlaceOn(ItemStack item, List<Material> canPlaceOn) {
        return this.setAdventureModePredicateMaterials(item, (ko<dfq>)kp.m, canPlaceOn);
    }

    public List<Material> getCanBreak(ItemStack item) {
        return this.getAdventureModePredicateMaterials(item, (ko<dfq>)kp.n);
    }

    public ItemStack setCanBreak(ItemStack item, List<Material> canBreak) {
        return this.setAdventureModePredicateMaterials(item, (ko<dfq>)kp.n, canBreak);
    }

    private List<Material> getAdventureModePredicateMaterials(ItemStack item, ko<dfq> nmsComponent) {
        List nmsPredicates;
        dfq nmsAdventurePredicate = (dfq)CraftItemStack.asNMSCopy((ItemStack)item).a(nmsComponent);
        if (nmsAdventurePredicate == null) {
            return null;
        }
        try {
            nmsPredicates = (List)AdventureModePredicate_predicates.get(nmsAdventurePredicate);
        }
        catch (Throwable e2) {
            Debug.echoError((Throwable)e2);
            return null;
        }
        ArrayList<Material> materials = new ArrayList<Material>();
        for (az nmsPredicate : nmsPredicates) {
            nmsPredicate.b().ifPresent(nmsHolderSet -> {
                for (jk nmsHolder : nmsHolderSet) {
                    materials.add(CraftMagicNumbers.getMaterial((duv)((duv)nmsHolder.a())));
                }
            });
        }
        return materials;
    }

    private ItemStack setAdventureModePredicateMaterials(ItemStack item, ko<dfq> nmsComponent, List<Material> materials) {
        dhp nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        dfq nmsAdventurePredicate = (dfq)nmsItemStack.a(nmsComponent);
        if (materials == null) {
            if (nmsAdventurePredicate == null) {
                return item;
            }
            nmsItemStack.e(nmsComponent);
            return CraftItemStack.asBukkitCopy((dhp)nmsItemStack);
        }
        az nmsPredicate = new az(Optional.of(jo.a(material -> (jk)mo.e.c(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey())).orElseThrow(), materials)), Optional.empty(), Optional.empty(), bo.a);
        nmsItemStack.b(nmsComponent, (Object)new dfq(List.of(nmsPredicate)));
        return CraftItemStack.asBukkitCopy((dhp)nmsItemStack);
    }

    public void setInventoryItem(Inventory inventory, ItemStack item, int slot) {
        if (inventory instanceof CraftInventoryPlayer && ((CraftInventoryPlayer)inventory).getInventory().j == null) {
            ((CraftInventoryPlayer)inventory).getInventory().a(slot, CraftItemStack.asNMSCopy((ItemStack)item));
        } else {
            inventory.setItem(slot, item);
        }
    }

    public String getDisplayName(ItemTag item) {
        if (!item.getItemMeta().hasDisplayName()) {
            return null;
        }
        dhp nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        xx nmsDisplayName = (xx)nmsItemStack.a(kp.g);
        return FormattedTextHelper.stringify((BaseComponent[])Handler.componentToSpigot(nmsDisplayName));
    }

    public List<String> getLore(ItemTag item) {
        if (!item.getItemMeta().hasLore()) {
            return null;
        }
        dhp nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        dkj nmsLore = (dkj)nmsItemStack.a(kp.j);
        ArrayList<String> outList = new ArrayList<String>(nmsLore.a().size());
        for (xx nmsLoreLine : nmsLore.a()) {
            outList.add(FormattedTextHelper.stringify((BaseComponent[])Handler.componentToSpigot(nmsLoreLine)));
        }
        return outList;
    }

    public void setDisplayName(ItemTag item, String name) {
        dhp nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        if (name == null || name.isEmpty()) {
            nmsItemStack.e(kp.g);
        } else {
            nmsItemStack.b(kp.g, (Object)Handler.componentToNMS(FormattedTextHelper.parse((String)name, (ChatColor)ChatColor.WHITE)));
        }
        item.setItemStack(CraftItemStack.asBukkitCopy((dhp)nmsItemStack));
    }

    public void setLore(ItemTag item, List<String> lore) {
        dhp nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        if (lore == null || lore.isEmpty()) {
            nmsItemStack.e(kp.j);
        } else {
            ArrayList<xx> nmsLore = new ArrayList<xx>(lore.size());
            for (String loreLine : lore) {
                nmsLore.add(Handler.componentToNMS(FormattedTextHelper.parse((String)loreLine, (ChatColor)ChatColor.WHITE)));
            }
            nmsItemStack.b(kp.j, (Object)new dkj(nmsLore));
        }
        item.setItemStack(CraftItemStack.asBukkitCopy((dhp)nmsItemStack));
    }

    public static ejm getCorrectStateForFluidBlock(drq world, ejm blockState, ja blockPos) {
        fga fluid = blockState.y();
        return !fluid.c() && !blockState.c((dqu)world, blockPos, jg.b) ? fluid.g() : blockState;
    }

    public static void renderFullMap(fhv worldmap, int xMin, int zMin, int xMax, int zMax) {
        awx world = ((CraftWorld)worldmap.mapView.getWorld()).getHandle();
        int scale = 1 << worldmap.g;
        int mapX = worldmap.d;
        int mapZ = worldmap.e;
        for (int x = xMin; x < xMax; ++x) {
            double d0 = 0.0;
            for (int z = zMin; z < zMax; ++z) {
                fge materialmapcolor;
                int k2 = (mapX / scale + x - 64) * scale;
                int l2 = (mapZ / scale + z - 64) * scale;
                LinkedHashMultiset multiset = LinkedHashMultiset.create();
                elv chunk = world.m(new ja(k2, 0, l2));
                if (chunk.F()) continue;
                dqv chunkcoordintpair = chunk.f();
                int i3 = k2 & 0xF;
                int j3 = l2 & 0xF;
                int k3 = 0;
                double d1 = 0.0;
                if (world.H_().h()) {
                    int l3 = k2 + l2 * 231871;
                    if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                        multiset.add((Object)dux.j.m().a((dqu)world, ja.c), 10);
                    } else {
                        multiset.add((Object)dux.b.m().a((dqu)world, ja.c), 100);
                    }
                    d1 = 100.0;
                } else {
                    ja.a blockposition_mutableblockposition = new ja.a();
                    ja.a blockposition_mutableblockposition1 = new ja.a();
                    for (int i4 = 0; i4 < scale; ++i4) {
                        for (int j4 = 0; j4 < scale; ++j4) {
                            ejm iblockdata;
                            int k4 = chunk.a(epp.a.b, i4 + i3, j4 + j3) + 1;
                            if (k4 <= world.M_() + 1) {
                                iblockdata = dux.I.m();
                            } else {
                                do {
                                    blockposition_mutableblockposition.d(chunkcoordintpair.d() + i4 + i3, --k4, chunkcoordintpair.e() + j4 + j3);
                                } while ((iblockdata = chunk.a_((ja)blockposition_mutableblockposition)).a((dqu)world, (ja)blockposition_mutableblockposition) == fge.a && k4 > world.M_());
                                if (k4 > world.M_() && !iblockdata.y().c()) {
                                    ejm iblockdata1;
                                    int l4 = k4 - 1;
                                    blockposition_mutableblockposition1.g((kf)blockposition_mutableblockposition);
                                    do {
                                        blockposition_mutableblockposition1.q(l4--);
                                        iblockdata1 = chunk.a_((ja)blockposition_mutableblockposition1);
                                        ++k3;
                                    } while (l4 > world.M_() && !iblockdata1.y().c());
                                    iblockdata = ItemHelperImpl.getCorrectStateForFluidBlock((drq)world, iblockdata, (ja)blockposition_mutableblockposition);
                                }
                            }
                            worldmap.a((dqu)world, chunkcoordintpair.d() + i4 + i3, chunkcoordintpair.e() + j4 + j3);
                            d1 += (double)k4 / (double)(scale * scale);
                            multiset.add((Object)iblockdata.a((dqu)world, (ja)blockposition_mutableblockposition));
                        }
                    }
                }
                k3 /= scale * scale;
                double d2 = (d1 - d0) * 4.0 / (double)(scale + 4) + ((double)(x + z & 1) - 0.5) * 0.4;
                int b0 = 1;
                if (d2 > 0.6) {
                    b0 = 2;
                }
                if (d2 < -0.6) {
                    b0 = 0;
                }
                if ((materialmapcolor = (fge)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)fge.a)) == fge.m) {
                    d2 = (double)k3 * 0.1 + (double)(x + z & 1) * 0.2;
                    b0 = 1;
                    if (d2 < 0.5) {
                        b0 = 2;
                    }
                    if (d2 > 0.9) {
                        b0 = 0;
                    }
                }
                d0 = d1;
                worldmap.a(x, z, (byte)(materialmapcolor.al * 4 + b0));
            }
        }
    }

    public boolean renderEntireMap(int mapId, int xMin, int zMin, int xMax, int zMax) {
        fhv worldmap = ((CraftServer)Bukkit.getServer()).getServer().a(drq.h).a(new fht(mapId));
        if (worldmap == null) {
            return false;
        }
        ItemHelperImpl.renderFullMap(worldmap, xMin, zMin, xMax, zMax);
        return true;
    }

    public BlockData getPlacedBlock(Material material) {
        dhl nmsItem = mo.h.b(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey())).orElse(null);
        if (nmsItem instanceof dfx) {
            duv block = ((dfx)nmsItem).c();
            return CraftBlockData.fromData((ejm)block.m());
        }
        return null;
    }

    public boolean isValidMix(ItemStack input, ItemStack ingredient) {
        dhp nmsInput = CraftItemStack.asNMSCopy((ItemStack)input);
        dhp nmsIngredient = CraftItemStack.asNMSCopy((ItemStack)ingredient);
        return MinecraftServer.getServer().bv().a(nmsInput, nmsIngredient);
    }

    public Map<NamespacedKey, ItemHelper.BrewingRecipe> getCustomBrewingRecipes() {
        if (customBrewingRecipes == null) {
            customBrewingRecipes = Maps.transformValues((Map)((Map)ReflectionHelper.getFieldValue(djl.class, (String)"customMixes", (Object)MinecraftServer.getServer().bv())), paperMix -> {
                if (PaperPotionMix_CLASS == null) {
                    PaperPotionMix_CLASS = paperMix.getClass();
                }
                RecipeChoice ingredient = this.convertChoice((Predicate)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"ingredient", (Object)paperMix));
                RecipeChoice input = this.convertChoice((Predicate)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"input", (Object)paperMix));
                ItemStack result = CraftItemStack.asBukkitCopy((dhp)((dhp)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"result", (Object)paperMix)));
                return new ItemHelper.BrewingRecipe(input, ingredient, result);
            });
        }
        return customBrewingRecipes;
    }

    private RecipeChoice convertChoice(Predicate<dhp> nmsPredicate) {
        if (nmsPredicate instanceof dme) {
            dme ingredient = (dme)nmsPredicate;
            return CraftRecipe.toBukkit((dme)ingredient);
        }
        return PaperAPITools.instance.createPredicateRecipeChoice(item -> nmsPredicate.test(CraftItemStack.asNMSCopy((ItemStack)item)));
    }

    public byte[] renderMap(MapView mapView, Player player) {
        return ((CraftMapView)mapView).render((CraftPlayer)((CraftPlayer)player)).buffer;
    }

    public int getFoodPoints(Material itemType) {
        return ((ddd)CraftMagicNumbers.getItem((Material)itemType).f().a(kp.v)).a();
    }
}

