/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import java.util.Arrays;
import java.util.HashSet;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;

public class EntityBreaksHangingScriptEvent
extends BukkitScriptEvent
implements Listener {
    public ElementTag cause;
    public EntityTag breaker;
    public EntityTag hanging;
    public LocationTag location;
    public HangingBreakByEntityEvent event;
    public static HashSet<String> notRelevantBreakables = new HashSet<String>(Arrays.asList("item", "held", "block", "because"));

    public EntityBreaksHangingScriptEvent() {
        this.registerCouldMatcher("<entity> breaks <hanging> (because <'cause'>)");
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!super.couldMatch(path)) {
            return false;
        }
        return !notRelevantBreakables.contains(path.eventArgLowerAt(2));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String entName = path.eventArgLowerAt(0);
        String hang = path.eventArgLowerAt(2);
        if (!this.breaker.tryAdvancedMatcher(entName, path.context)) {
            return false;
        }
        if (!hang.equals("hanging") && !this.hanging.tryAdvancedMatcher(hang, path.context)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (path.eventArgLowerAt(3).equals("because") && !path.eventArgLowerAt(4).equals(this.cause.asLowerString())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.breaker);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "cause" -> this.cause;
            case "breaker" -> this.breaker.getDenizenObject();
            case "hanging" -> this.hanging;
            case "location" -> this.location;
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onHangingBreaks(HangingBreakByEntityEvent event) {
        this.hanging = new EntityTag((Entity)event.getEntity());
        this.cause = new ElementTag((Enum<?>)event.getCause());
        this.location = new LocationTag(this.hanging.getLocation());
        this.breaker = new EntityTag(event.getRemover());
        this.event = event;
        this.fire((Event)event);
    }
}

