/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.queues.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.scripts.queues.ScriptEngine;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.utilities.CoreConfiguration;

public class TimedQueue
extends ScriptQueue {
    private long ticks;
    protected boolean paused = false;
    public DelayTracker delay;
    public int tickCounter = 0;

    public void delayFor(DurationTag duration) {
        this.delay = new DeltaTimeDelayTracker(duration.getMillis());
    }

    public boolean isDelayed() {
        return this.delay != null && this.delay.isDelayed();
    }

    public TimedQueue(String id) {
        this(id, new DurationTag(CoreConfiguration.scriptQueueSpeed));
    }

    public TimedQueue(String id, long ticks) {
        super(id);
        this.ticks = ticks;
    }

    public TimedQueue(String id, DurationTag timing) {
        super(id);
        this.ticks = timing.getTicks();
    }

    public boolean isInstantSpeed() {
        return this.ticks <= 0L;
    }

    public DurationTag getSpeed() {
        return new DurationTag(this.ticks);
    }

    public TimedQueue setPaused(boolean paused) {
        this.paused = paused;
        return this;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public TimedQueue setSpeed(long ticks) {
        this.ticks = ticks;
        return this;
    }

    @Override
    public void onStart() {
        this.revolve();
        if (this.script_entries.isEmpty() && this.holdingOn == null) {
            return;
        }
        DenizenCore.timedQueues.add(this);
    }

    public final void tryRevolveOnce() {
        if ((long)this.tickCounter++ >= this.ticks) {
            this.tickCounter = 0;
            this.revolve();
        }
    }

    public void revolve() {
        if (this.script_entries.isEmpty() && this.holdingOn == null) {
            if (!this.waitWhenEmpty) {
                this.stop();
            }
            return;
        }
        if (this.paused || this.isDelayed()) {
            return;
        }
        ScriptEngine.revolve(this);
        if (this.script_entries.isEmpty() && this.holdingOn == null && !this.waitWhenEmpty) {
            this.stop();
        }
    }

    @Override
    public String getName() {
        return "TimedQueue";
    }

    public static class DeltaTimeDelayTracker
    implements DelayTracker {
        public long serverTimeEnd;

        public DeltaTimeDelayTracker(long millis) {
            this.serverTimeEnd = DenizenCore.serverTimeMillis + millis;
        }

        @Override
        public boolean isDelayed() {
            return this.serverTimeEnd > DenizenCore.serverTimeMillis;
        }
    }

    @FunctionalInterface
    public static interface DelayTracker {
        public boolean isDelayed();
    }
}

