/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.properties.entity.EntityProperty;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import net.citizensnpcs.trait.Age;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Breedable;

public class EntityAge
extends EntityProperty<ElementTag> {
    public static boolean describes(EntityTag entity) {
        return entity.getBukkitEntity() instanceof Ageable;
    }

    public EntityAge(EntityTag entity) {
        super(entity);
    }

    @Override
    public ElementTag getPropertyValue() {
        return new ElementTag(this.as(Ageable.class).getAge());
    }

    @Override
    public void setPropertyValue(ElementTag param, Mechanism mechanism) {
        String input;
        ListTag listHack = param.asType(ListTag.class, mechanism.context);
        if (listHack.isEmpty()) {
            mechanism.echoError("Missing value for 'age' mechanism!");
            return;
        }
        switch (input = CoreUtilities.toLowerCase(listHack.get(0))) {
            case "baby": {
                this.setAge(-24000);
                break;
            }
            case "adult": {
                this.setAge(0);
                break;
            }
            default: {
                if (!ArgumentHelper.matchesInteger(input)) {
                    mechanism.echoError("Invalid age '" + input + "': must be 'baby', 'adult', or a valid age number.");
                    return;
                }
                this.setAge(new ElementTag(input).asInt());
            }
        }
        if (listHack.size() > 1) {
            BukkitImplDeprecations.oldAgeLockedControls.warn(mechanism.context);
            Object object = this.getEntity();
            if (!(object instanceof Breedable)) {
                return;
            }
            Breedable breedable = (Breedable)object;
            switch (CoreUtilities.toLowerCase(listHack.get(1))) {
                case "locked": {
                    breedable.setAgeLock(true);
                    break;
                }
                case "unlocked": {
                    breedable.setAgeLock(false);
                    break;
                }
                default: {
                    mechanism.echoError("Invalid lock state '" + listHack.get(1) + "': must be 'locked' or 'unlocked'.");
                }
            }
        }
    }

    @Override
    public String getPropertyId() {
        return "age";
    }

    public void setAge(int age) {
        if (((EntityTag)this.object).isCitizensNPC()) {
            ((Age)((EntityTag)this.object).getDenizenNPC().getCitizen().getOrAddTrait(Age.class)).setAge(age);
        } else {
            this.as(Ageable.class).setAge(age);
        }
    }

    public static void register() {
        EntityAge.autoRegister("age", EntityAge.class, ElementTag.class, false, new String[0]);
        PropertyParser.registerTag(EntityAge.class, ElementTag.class, "is_baby", (attribute, prop) -> new ElementTag(!prop.as(Ageable.class).isAdult()), new String[0]);
    }
}

