/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.flags.RedirectionFlagTracker;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ColorTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.entity.EntityType;

public class BiomeTag
implements ObjectTag,
Adjustable,
FlaggableObject {
    private BiomeNMS biome;
    String prefix = "biome";
    public static final ObjectTagProcessor<BiomeTag> tagProcessor = new ObjectTagProcessor();

    @Fetchable(value="b")
    public static BiomeTag valueOf(String string, TagContext context) {
        BiomeNMS biome;
        if (string.startsWith("b@")) {
            string = string.substring(2);
        }
        string = CoreUtilities.toLowerCase(string);
        int comma = string.indexOf(44);
        String worldName = null;
        String biomeName = string;
        if (comma != -1) {
            worldName = string.substring(0, comma);
            biomeName = string.substring(comma + 1);
        }
        World world = (World)Bukkit.getWorlds().get(0);
        if (worldName != null) {
            WorldTag worldTag = WorldTag.valueOf(worldName, context);
            if (worldTag == null || worldTag.getWorld() == null) {
                return null;
            }
            world = worldTag.getWorld();
        }
        if ((biome = NMSHandler.instance.getBiomeNMS(world, Utilities.parseNamespacedKey(biomeName))) == null) {
            return null;
        }
        return new BiomeTag(biome);
    }

    public static boolean matches(String arg) {
        if (arg.startsWith("b@")) {
            return true;
        }
        return BiomeTag.valueOf(arg, CoreUtilities.noDebugContext) != null;
    }

    public BiomeTag(Biome biome) {
        this.biome = NMSHandler.instance.getBiomeNMS((World)Bukkit.getWorlds().get(0), biome.getKey());
    }

    public BiomeTag(BiomeNMS biome) {
        this.biome = biome;
    }

    public BiomeNMS getBiome() {
        return this.biome;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String identify() {
        return "b@" + this.biome.world.getName() + "," + Utilities.namespacedKeyToString(this.biome.getKey());
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        if (prefix != null) {
            this.prefix = prefix;
        }
        return this;
    }

    @Override
    public AbstractFlagTracker getFlagTracker() {
        return new RedirectionFlagTracker(DenizenCore.serverFlagMap, "__biomes." + Utilities.namespacedKeyToString(this.biome.getKey()).replace(".", "&dot"));
    }

    @Override
    public void reapplyTracker(AbstractFlagTracker tracker) {
    }

    public static void register() {
        AbstractFlagTracker.registerFlagHandlers(tagProcessor);
        tagProcessor.registerTag(ElementTag.class, "downfall_type", (attribute, object) -> {
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19)) {
                BukkitImplDeprecations.biomeGlobalDownfallType.warn(attribute.context);
            }
            return new ElementTag(object.biome.getDownfallType());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "name", (attribute, object) -> new ElementTag(Utilities.namespacedKeyToString(object.biome.getKey()), true), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "humidity", (attribute, object) -> new ElementTag(object.biome.getHumidity()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "base_temperature", (attribute, object) -> new ElementTag(object.biome.getBaseTemperature()), "temperature");
        tagProcessor.registerTag(ListTag.class, "spawnable_entities", (attribute, object) -> {
            List<EntityType> entityTypes;
            if (attribute.startsWith("ambient", 2)) {
                BukkitImplDeprecations.biomeSpawnableTag.warn(attribute.context);
                attribute.fulfill(1);
                entityTypes = object.biome.getAmbientEntities();
            } else if (attribute.startsWith("creatures", 2)) {
                BukkitImplDeprecations.biomeSpawnableTag.warn(attribute.context);
                attribute.fulfill(1);
                entityTypes = object.biome.getCreatureEntities();
            } else if (attribute.startsWith("monsters", 2)) {
                BukkitImplDeprecations.biomeSpawnableTag.warn(attribute.context);
                attribute.fulfill(1);
                entityTypes = object.biome.getMonsterEntities();
            } else if (attribute.startsWith("water", 2)) {
                BukkitImplDeprecations.biomeSpawnableTag.warn(attribute.context);
                attribute.fulfill(1);
                entityTypes = object.biome.getWaterEntities();
            } else {
                String type;
                entityTypes = switch (type = attribute.hasParam() ? CoreUtilities.toLowerCase(attribute.getParam()) : "all") {
                    case "ambient" -> object.biome.getAmbientEntities();
                    case "creatures" -> object.biome.getCreatureEntities();
                    case "monsters" -> object.biome.getMonsterEntities();
                    case "water" -> object.biome.getWaterEntities();
                    default -> object.biome.getAllEntities();
                };
            }
            return new ListTag(entityTypes, ElementTag::new);
        }, new String[0]);
        tagProcessor.registerTag(ColorTag.class, "foliage_color", (attribute, object) -> ColorTag.fromRGB(object.biome.getFoliageColor()), new String[0]);
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19)) {
            tagProcessor.registerTag(ElementTag.class, LocationTag.class, "temperature_at", (attribute, object, param) -> new ElementTag(object.biome.getTemperatureAt((Location)param)), new String[0]);
            tagProcessor.registerTag(ElementTag.class, LocationTag.class, "downfall_at", (attribute, object, param) -> new ElementTag(object.biome.getDownfallTypeAt((Location)param)), new String[0]);
            tagProcessor.registerTag(ElementTag.class, "has_downfall", (attribute, object) -> new ElementTag(object.biome.hasDownfall()), new String[0]);
            tagProcessor.registerTag(ColorTag.class, "fog_color", (attribute, object) -> ColorTag.fromRGB(object.biome.getFogColor()), new String[0]);
            tagProcessor.registerTag(ColorTag.class, "water_fog_color", (attribute, object) -> ColorTag.fromRGB(object.biome.getWaterFogColor()), new String[0]);
            tagProcessor.registerMechanism("fog_color", false, ColorTag.class, (object, mechanism, input) -> object.biome.setFogColor(input.asRGB()), new String[0]);
            tagProcessor.registerMechanism("water_fog_color", false, ColorTag.class, (object, mechanism, input) -> object.biome.setWaterFogColor(input.asRGB()), new String[0]);
            tagProcessor.registerMechanism("has_downfall", false, ElementTag.class, (object, mechanism, input) -> {
                if (mechanism.requireBoolean()) {
                    object.biome.setHasDownfall(input.asBoolean());
                }
            }, new String[0]);
        }
        tagProcessor.registerMechanism("foliage_color", false, ColorTag.class, (object, mechanism, color) -> object.biome.setFoliageColor(color.asRGB()), new String[0]);
        tagProcessor.registerMechanism("humidity", false, ElementTag.class, (object, mechanism, input) -> {
            if (mechanism.requireFloat()) {
                object.biome.setHumidity(input.asFloat());
            }
        }, new String[0]);
        tagProcessor.registerMechanism("base_temperature", false, ElementTag.class, (object, mechanism, input) -> {
            if (mechanism.requireFloat()) {
                object.biome.setBaseTemperature(input.asFloat());
            }
        }, "temperature");
        tagProcessor.registerMechanism("downfall_type", false, ElementTag.class, (object, mechanism, input) -> {
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19)) {
                BukkitImplDeprecations.biomeSettingDownfallType.warn(mechanism.context);
                return;
            }
            if (mechanism.requireEnum(BiomeNMS.DownfallType.class)) {
                object.biome.setPrecipitation(input.asEnum(BiomeNMS.DownfallType.class));
            }
        }, new String[0]);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        mechanism.echoError("Cannot apply properties to a biome!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        tagProcessor.processMechanism(this, mechanism);
    }
}

