/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockShearEntityEvent;

public class BlockShearEntityScriptEvent
extends BukkitScriptEvent
implements Listener {
    public LocationTag location;
    public EntityTag entity;
    public BlockShearEntityEvent event;

    public BlockShearEntityScriptEvent() {
        this.registerCouldMatcher("<block> shears <entity>");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!path.tryArgObject(0, this.location)) {
            return false;
        }
        if (!path.tryArgObject(2, this.entity)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "location" -> this.location;
            case "tool" -> new ItemTag(this.event.getTool());
            case "entity" -> this.entity;
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onShear(BlockShearEntityEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.entity = new EntityTag(event.getEntity());
        this.event = event;
        this.fire((Event)event);
    }
}

