/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.triggers.core;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.npc.traits.TriggerTrait;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptContainer;
import com.denizenscript.denizen.scripts.triggers.AbstractTrigger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class ProximityTrigger
extends AbstractTrigger
implements Listener {
    private static int maxProximityDistance = 75;
    int taskID = -1;
    private static Map<UUID, Set<UUID>> proximityTracker = new HashMap<UUID, Set<UUID>>();

    @Override
    public void onEnable() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)Denizen.getInstance());
        this.taskID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Denizen.getInstance(), () -> {
            if (this.timesUsed == 0) {
                return;
            }
            Collection allPlayers = Bukkit.getOnlinePlayers();
            for (NPCRegistry registry : CitizensAPI.getNPCRegistries()) {
                for (NPC citizensNPC : registry) {
                    if (citizensNPC == null || !citizensNPC.isSpawned() || !citizensNPC.hasTrait(TriggerTrait.class) || !((TriggerTrait)citizensNPC.getOrAddTrait(TriggerTrait.class)).isEnabled(this.name)) continue;
                    NPCTag npc = new NPCTag(citizensNPC);
                    TriggerTrait triggerTrait = npc.getTriggerTrait();
                    for (Player bukkitPlayer : allPlayers) {
                        this.tryProcessSinglePair(npc, triggerTrait, bukkitPlayer);
                    }
                }
            }
        }, 5L, 5L);
    }

    public final void tryProcessSinglePair(NPCTag npc, TriggerTrait triggerTrait, Player bukkitPlayer) {
        boolean exitedProximity = this.hasExitedProximityOf(bukkitPlayer, npc);
        if (!npc.getWorld().equals((Object)bukkitPlayer.getWorld()) && exitedProximity) {
            return;
        }
        if (!this.isCloseEnough(bukkitPlayer, npc) && exitedProximity) {
            return;
        }
        PlayerTag player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)bukkitPlayer);
        double radius = triggerTrait.getRadius(this.name);
        LocationTag npcLocation = npc.getLocation();
        double distance = npcLocation.getWorld() != player.getWorld() ? radius + 1.0 : npcLocation.distance(player.getLocation());
        if (!exitedProximity) {
            if (distance >= radius) {
                if (!triggerTrait.triggerCooldownOnly(this, player)) {
                    return;
                }
                this.exitProximityOf(bukkitPlayer, npc);
                npc.action("exit proximity", player);
                this.parseAll(npc, player, "EXIT");
            } else {
                npc.action("move proximity", player);
                this.parseAll(npc, player, "MOVE");
            }
        } else if (distance <= radius) {
            if (!triggerTrait.triggerCooldownOnly(this, player)) {
                return;
            }
            this.enterProximityOf(bukkitPlayer, npc);
            npc.action("enter proximity", player);
            this.parseAll(npc, player, "ENTRY");
        }
    }

    public void parseAll(NPCTag npc, PlayerTag player, String id) {
        List<InteractScriptContainer> scripts = npc.getInteractScriptsQuietly(player, ProximityTrigger.class);
        if (scripts != null) {
            for (InteractScriptContainer container : scripts) {
                this.parse(npc, player, container, id);
            }
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Set<UUID> npcs = proximityTracker.remove(event.getPlayer().getUniqueId());
        if (npcs == null) {
            return;
        }
        PlayerTag player = new PlayerTag(event.getPlayer());
        for (UUID id : npcs) {
            NPC citizen = CitizensAPI.getNPCRegistry().getByUniqueId(id);
            if (citizen == null) continue;
            NPCTag npc = new NPCTag(citizen);
            TriggerTrait triggerTrait = (TriggerTrait)citizen.getTraitNullable(TriggerTrait.class);
            if (triggerTrait == null) continue;
            if (!triggerTrait.triggerCooldownOnly(this, player)) {
                return;
            }
            npc.action("exit proximity", player);
            this.parseAll(npc, player, "EXIT");
        }
    }

    @Override
    public void onDisable() {
        Bukkit.getScheduler().cancelTask(this.taskID);
    }

    private boolean isCloseEnough(Player player, NPCTag npc) {
        Location pLoc = player.getLocation();
        LocationTag nLoc = npc.getLocation();
        return pLoc.getWorld() == nLoc.getWorld() && !(pLoc.distanceSquared((Location)nLoc) > (double)(maxProximityDistance * maxProximityDistance));
    }

    private boolean hasExitedProximityOf(Player player, NPCTag npc) {
        Set<UUID> existing = proximityTracker.get(player.getUniqueId());
        if (existing == null) {
            return true;
        }
        return !existing.contains(npc.getCitizen().getUniqueId());
    }

    private void enterProximityOf(Player player, NPCTag npc) {
        Set npcs = proximityTracker.computeIfAbsent(player.getUniqueId(), k -> new HashSet());
        npcs.add(npc.getCitizen().getUniqueId());
    }

    private void exitProximityOf(Player player, NPCTag npc) {
        Set<UUID> npcs = proximityTracker.get(player.getUniqueId());
        if (npcs == null) {
            return;
        }
        npcs.remove(npc.getCitizen().getUniqueId());
        if (npcs.isEmpty()) {
            proximityTracker.remove(player.getUniqueId());
        }
    }
}

