/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.scripts.containers.core.BookScriptContainer;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class PlayerEditsBookScriptEvent
extends BukkitScriptEvent
implements Listener {
    public PlayerEditBookEvent event;

    public PlayerEditsBookScriptEvent() {
        this.registerCouldMatcher("player edits book");
        this.registerCouldMatcher("player signs book");
        this.registerTextDetermination("not_signing", evt -> evt.event.setSigning(false));
        this.registerOptionalDetermination(null, ScriptTag.class, (evt, context, value) -> {
            ScriptContainer patt0$temp = value.getContainer();
            if (patt0$temp instanceof BookScriptContainer) {
                BookScriptContainer script = (BookScriptContainer)patt0$temp;
                ItemTag dBook = script.getBookFrom(context);
                BookMeta bookMeta = (BookMeta)dBook.getItemMeta();
                if (dBook.getBukkitMaterial() == Material.WRITABLE_BOOK) {
                    evt.event.setSigning(false);
                }
                evt.event.setNewBookMeta(bookMeta);
                return true;
            }
            Debug.echoError("Script '" + String.valueOf(value) + "' is valid, but not of type 'book'!");
            return false;
        });
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String action = path.eventArgLowerAt(1);
        if (!(action.equals("edits") && !this.event.isSigning() || action.equals("signs") && this.event.isSigning())) {
            return false;
        }
        if (!this.runInCheck(path, this.event.getPlayer().getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "signing" -> new ElementTag(this.event.isSigning());
            case "title" -> {
                if (this.event.isSigning()) {
                    yield new ElementTag(this.event.getNewBookMeta().getTitle(), true);
                }
                yield null;
            }
            case "pages" -> new ElementTag(this.event.getNewBookMeta().getPageCount());
            case "book" -> {
                ItemStack book = new ItemStack(this.event.isSigning() ? Material.WRITTEN_BOOK : Material.WRITABLE_BOOK);
                book.setItemMeta((ItemMeta)this.event.getNewBookMeta());
                yield new ItemTag(book);
            }
            case "old_book" -> {
                ItemStack book = new ItemStack(Material.WRITABLE_BOOK);
                book.setItemMeta((ItemMeta)this.event.getPreviousBookMeta());
                yield new ItemTag(book);
            }
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onPlayerEditsBook(PlayerEditBookEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

