/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.scripts.commands.generator.ArgSubType;
import com.denizenscript.denizencore.scripts.commands.generator.ArgUnparsed;
import com.denizenscript.denizencore.tags.ParseableTag;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;

public class TitleCommand
extends AbstractCommand {
    public TitleCommand() {
        this.setName("title");
        this.setSyntax("title (title:<text>) (subtitle:<text>) (fade_in:<duration>/{1s}) (stay:<duration>/{3s}) (fade_out:<duration>/{1s}) (targets:<player>|...) (per_player)");
        this.setRequiredArguments(1, 7);
        this.addRemappedPrefixes("targets", "target");
        this.isProcedural = false;
        this.autoCompile();
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="title") @ArgPrefixed @ArgUnparsed @ArgDefaultNull String strTitle, @ArgName(value="subtitle") @ArgPrefixed @ArgUnparsed @ArgDefaultNull String strSubTitle, @ArgName(value="fade_in") @ArgPrefixed @ArgDefaultText(value="1s") DurationTag fadeIn, @ArgName(value="stay") @ArgPrefixed @ArgDefaultText(value="3s") DurationTag stay, @ArgName(value="fade_out") @ArgPrefixed @ArgDefaultText(value="1s") DurationTag fadeOut, @ArgName(value="targets") @ArgPrefixed @ArgDefaultNull @ArgSubType(value=PlayerTag.class) List<PlayerTag> players, @ArgName(value="per_player") boolean perPlayer) {
        if (strTitle == null && strSubTitle == null) {
            Debug.echoError("Must have a title or subtitle!");
            return;
        }
        if (players == null) {
            if (!Utilities.entryHasPlayer(scriptEntry)) {
                Debug.echoError("Must specify target(s).");
                return;
            }
            players = List.of(Utilities.getEntryPlayer(scriptEntry));
        }
        BukkitTagContext context = perPlayer ? new BukkitTagContext((BukkitTagContext)scriptEntry.getContext()) : (BukkitTagContext)scriptEntry.getContext();
        ParseableTag parseableTitle = TagManager.parseTextToTag(strTitle, context);
        ParseableTag parseableSubTitle = TagManager.parseTextToTag(strSubTitle, context);
        String parsedTitle = perPlayer ? null : TitleCommand.parse(parseableTitle, context);
        String parsedSubTitle = perPlayer ? null : TitleCommand.parse(parseableSubTitle, context);
        for (PlayerTag player : players) {
            if (!player.isOnline()) {
                Debug.echoDebug((Debuggable)scriptEntry, "Player is offline, can't send title to them. Skipping.");
                continue;
            }
            if (perPlayer) {
                context.player = player;
                parsedTitle = TitleCommand.parse(parseableTitle, context);
                parsedSubTitle = TitleCommand.parse(parseableSubTitle, context);
            }
            NMSHandler.packetHelper.showTitle(player.getPlayerEntity(), parsedTitle, parsedSubTitle, fadeIn.getTicksAsInt(), stay.getTicksAsInt(), fadeOut.getTicksAsInt());
        }
    }

    public static String parse(ParseableTag tag, BukkitTagContext context) {
        return tag == null ? null : tag.parse(context).toString();
    }
}

