/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.MapTagFlagTracker;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.scripts.commands.core.FlagCommand;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.utilities.data.ActionableDataProvider;
import com.denizenscript.denizencore.utilities.data.DataAction;
import com.denizenscript.denizencore.utilities.data.DataActionHelper;

public class ItemFlags
implements Property {
    public static final String[] handledTags = new String[]{"with_flag"};
    public static final String[] handledMechs = new String[]{"flag", "flag_map"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag;
    }

    public static ItemFlags getFrom(ObjectTag item) {
        if (!ItemFlags.describes(item)) {
            return null;
        }
        return new ItemFlags((ItemTag)item);
    }

    public ItemFlags(ItemTag item) {
        this.item = item;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("with_flag")) {
            ItemTag item = new ItemTag(this.item.getItemStack().clone());
            FlagCommand.FlagActionProvider provider = new FlagCommand.FlagActionProvider();
            provider.tracker = item.getFlagTracker();
            DataAction action = DataActionHelper.parse((ActionableDataProvider)provider, attribute.getParam(), attribute.context);
            if (attribute.startsWith("duration", 2)) {
                provider.expiration = new TimeTag(TimeTag.now().millis() + attribute.getContextObject(2).asType(DurationTag.class, attribute.context).getMillis());
                attribute.fulfill(1);
            }
            action.execute(attribute.context);
            item.reapplyTracker(provider.tracker);
            return item.getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        AbstractFlagTracker tracker = this.item.getFlagTracker();
        if (tracker instanceof MapTagFlagTracker && ((MapTagFlagTracker)tracker).map.isEmpty()) {
            return null;
        }
        return tracker.toString();
    }

    @Override
    public String getPropertyId() {
        return "flag_map";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("flag_map") && mechanism.requireObject(MapTag.class)) {
            this.item.reapplyTracker(new MapTagFlagTracker(mechanism.valueAsType(MapTag.class)));
        }
        if (mechanism.matches("flag")) {
            FlagCommand.FlagActionProvider provider = new FlagCommand.FlagActionProvider();
            provider.tracker = this.item.getFlagTracker();
            DataAction action = DataActionHelper.parse((ActionableDataProvider)provider, mechanism.getValue().asString(), mechanism.context);
            action.execute(mechanism.context);
            this.item.reapplyTracker(provider.tracker);
        }
    }
}

