/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.item;

import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.command.TabCompleteHelper;
import com.denizenscript.denizen.utilities.inventory.SlotHelper;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.scripts.commands.generator.ArgSubType;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class GiveCommand
extends AbstractCommand {
    public GiveCommand() {
        this.setName("give");
        this.setSyntax("give [<item>|...] (quantity:<#>) (unlimit_stack_size) (to:<inventory>) (slot:<slot>) (allowed_slots:<slot-matcher>) (ignore_leftovers)");
        this.setRequiredArguments(1, 7);
        this.isProcedural = false;
        this.addRemappedPrefixes("to", "t");
        this.autoCompile();
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        TabCompleteHelper.tabCompleteItems(tab);
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="quantity") @ArgPrefixed @ArgDefaultText(value="-1") double quantity, @ArgName(value="unlimit_stack_size") boolean unlimitStackSize, @ArgName(value="ignore_leftovers") boolean ignoreLeftovers, @ArgName(value="allowed_slots") @ArgPrefixed @ArgDefaultNull String allowedSlots, @ArgName(value="to") @ArgPrefixed @ArgDefaultNull InventoryTag inventory, @ArgName(value="slot") @ArgPrefixed @ArgDefaultText(value="1") String slot, @ArgName(value="items") @ArgLinear @ArgSubType(value=ItemTag.class) List<ItemTag> items) {
        ListTag leftoverSave = new ListTag();
        if (inventory == null) {
            if (!Utilities.entryHasPlayer(scriptEntry)) {
                throw new InvalidArgumentsRuntimeException("Must specify an inventory to give to!");
            }
            inventory = Utilities.getEntryPlayer(scriptEntry).getInventory();
        }
        boolean limited = !unlimitStackSize;
        for (ItemTag item : items) {
            int slotId;
            ItemStack is = new ItemStack(item.getItemStack());
            if (is.getType() == Material.AIR) {
                Debug.echoError("Cannot give air!");
                continue;
            }
            if (quantity >= 0.0) {
                is.setAmount((int)quantity);
            }
            if ((slotId = SlotHelper.nameToIndexFor(slot, inventory.getInventory().getHolder())) == -1) {
                Debug.echoError("The input '" + slot + "' is not a valid slot!");
                return;
            }
            List<ItemStack> leftovers = inventory.addWithLeftovers(slotId, allowedSlots, limited, is);
            for (ItemStack extraItem : leftovers) {
                leftoverSave.addObject(new ItemTag(extraItem));
            }
            if (leftovers.isEmpty() || ignoreLeftovers) continue;
            Debug.echoDebug((Debuggable)scriptEntry, "The inventory didn't have enough space, the rest of the items have been placed on the floor.");
            LocationTag inventoryLocation = inventory.getLocation();
            if (inventoryLocation == null) {
                Debug.echoError("Cannot drop extras from failed give command - no inventory location.");
                return;
            }
            for (ItemStack leftoverItem : leftovers) {
                inventoryLocation.getWorld().dropItem((Location)inventoryLocation, leftoverItem);
            }
        }
        scriptEntry.saveObject("leftover_items", leftoverSave);
    }
}

