/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import org.bukkit.Bukkit;
import org.bukkit.ServerTickManager;

public class TickCommand
extends AbstractCommand {
    public TickCommand() {
        this.setName("tick");
        this.setSyntax("tick [rate/step/sprint/freeze/reset] (amount:<#.#>/cancel)");
        this.setRequiredArguments(1, 2);
        this.isProcedural = false;
        this.autoCompile();
    }

    public static void autoExecute(@ArgName(value="action") TickActions action, @ArgName(value="amount") @ArgPrefixed @ArgDefaultText(value="0") float amount, @ArgName(value="cancel") boolean cancel) {
        ServerTickManager tickManager = Bukkit.getServerTickManager();
        switch (action.ordinal()) {
            case 0: {
                if (amount < 1.0f || amount > 10000.0f) {
                    throw new InvalidArgumentsRuntimeException("Invalid input! Tick rate must be a decimal number between 1.0 and 10000.0 (inclusive)!");
                }
                tickManager.setTickRate(amount);
                break;
            }
            case 1: {
                if (cancel) {
                    tickManager.stopStepping();
                    return;
                }
                if (amount < 1.0f) {
                    throw new InvalidArgumentsRuntimeException("The step action must have a number input not less than 1!");
                }
                tickManager.stepGameIfFrozen((int)amount);
                break;
            }
            case 2: {
                if (cancel) {
                    tickManager.stopSprinting();
                    return;
                }
                if (amount < 1.0f) {
                    throw new InvalidArgumentsRuntimeException("The sprint action must have a number input not less than 1!");
                }
                tickManager.requestGameToSprint((int)amount);
                break;
            }
            case 3: {
                tickManager.setFrozen(!cancel);
                break;
            }
            case 4: {
                tickManager.setTickRate(20.0f);
            }
        }
    }

    public static enum TickActions {
        RATE,
        STEP,
        SPRINT,
        FREEZE,
        RESET;

    }
}

