/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.containers.core.FormatScriptContainer;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.List;
import java.util.Set;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChatEvent;

public class ChatScriptEvent
extends BukkitScriptEvent
implements Listener {
    public PlayerChatEvent pcEvent;
    public AsyncPlayerChatEvent apcEvent;
    public PlayerTag player;
    public SyncChatHandler sch = new SyncChatHandler();
    public AsyncChatHandler asch = new AsyncChatHandler();
    public static final String TEXT_CHAR = String.valueOf('\u0000');
    public static final String NAME_CHAR = String.valueOf('\u0004');

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("player chats");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.player.getLocation())) {
            return false;
        }
        if (!ChatScriptEvent.runGenericSwitchCheck(path, "message", this.getMessage())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public void init() {
        this.initListener((Listener)(Settings.worldScriptChatEventAsynchronous() ? this.asch : this.sch));
    }

    @Override
    public void initForPriority(EventPriority priority, Listener listener) {
        super.initForPriority(priority, (Listener)(Settings.worldScriptChatEventAsynchronous() ? this.asch : this.sch));
    }

    @Override
    public ChatScriptEvent clone() {
        ChatScriptEvent event = (ChatScriptEvent)super.clone();
        event.sch = event.new SyncChatHandler();
        event.asch = event.new AsyncChatHandler();
        return event;
    }

    public String getFormatText(FormatScriptContainer formatScript) {
        String text = formatScript.getRawFormat().replace("<[text]>", TEXT_CHAR).replace("<[name]>", NAME_CHAR);
        return TagManager.tag(text, new BukkitTagContext(this.player, null, new ScriptTag(formatScript))).replace("%", "%%").replace(TEXT_CHAR, "%2$s").replace(NAME_CHAR, "%1$s");
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag) {
            String determination = determinationObj.toString();
            String lower = CoreUtilities.toLowerCase(determination);
            if (lower.startsWith("format:")) {
                String name = determination.substring("format:".length());
                FormatScriptContainer formatscr = (FormatScriptContainer)ScriptRegistry.getScriptContainer(name);
                if (formatscr == null) {
                    Debug.echoError("Could not find format script matching '" + name + "'");
                } else {
                    String formatstr = this.getFormatText(formatscr);
                    if (CoreConfiguration.debugVerbose) {
                        Debug.log("Setting format to " + formatstr);
                    }
                    if (this.pcEvent != null) {
                        this.pcEvent.setFormat(formatstr);
                    } else {
                        this.apcEvent.setFormat(formatstr);
                    }
                }
                return true;
            }
            if (lower.startsWith("raw_format:")) {
                String form = determination.substring("raw_format:".length());
                if (this.pcEvent != null) {
                    this.pcEvent.setFormat(form);
                } else {
                    this.apcEvent.setFormat(form);
                }
                return true;
            }
            if (lower.startsWith("recipients:")) {
                String rec_new = determination.substring("recipients:".length());
                ListTag recs = ListTag.valueOf(rec_new, this.getTagContext(path));
                List<PlayerTag> players = recs.filter(PlayerTag.class, path.container, true);
                Set recipients = this.pcEvent != null ? this.pcEvent.getRecipients() : this.apcEvent.getRecipients();
                recipients.clear();
                for (PlayerTag player : players) {
                    recipients.add(player.getPlayerEntity());
                }
                return true;
            }
            if (this.pcEvent != null) {
                this.pcEvent.setMessage(determination);
            } else {
                this.apcEvent.setMessage(determination);
            }
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    public String getMessage() {
        return this.pcEvent != null ? this.pcEvent.getMessage() : this.apcEvent.getMessage();
    }

    public String getFormat() {
        return this.pcEvent != null ? this.pcEvent.getFormat() : this.apcEvent.getFormat();
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "message": {
                return new ElementTag(this.getMessage(), true);
            }
            case "format": {
                return new ElementTag(this.getFormat(), true);
            }
            case "full_text": {
                return new ElementTag(String.format(this.getFormat(), this.player.getPlayerEntity().getDisplayName(), this.getMessage()), true);
            }
        }
        if (name.equals("recipients")) {
            ListTag list = new ListTag();
            for (Player tplayer : this.pcEvent != null ? this.pcEvent.getRecipients() : this.apcEvent.getRecipients()) {
                list.addObject(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)tplayer));
            }
            return list;
        }
        return super.getContext(name);
    }

    class SyncChatHandler
    implements Listener {
        SyncChatHandler() {
        }

        @EventHandler
        public void onSyncChat(PlayerChatEvent event) {
            ChatScriptEvent.this.pcEvent = event;
            ChatScriptEvent.this.apcEvent = null;
            ChatScriptEvent.this.player = new PlayerTag(event.getPlayer());
            ChatScriptEvent.this.fire((Event)event);
        }
    }

    class AsyncChatHandler
    implements Listener {
        AsyncChatHandler() {
        }

        @EventHandler
        public void onAsyncChat(AsyncPlayerChatEvent event) {
            ChatScriptEvent.this.pcEvent = null;
            ChatScriptEvent.this.apcEvent = event;
            ChatScriptEvent.this.player = new PlayerTag(event.getPlayer());
            ChatScriptEvent.this.fire((Event)event);
        }
    }
}

