/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.properties.entity.EntityProperty;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import org.bukkit.entity.Mob;
import org.bukkit.inventory.EntityEquipment;

public class EntityEquipmentDropChance
extends EntityProperty<MapTag> {
    public static boolean describes(EntityTag entity) {
        return entity.getBukkitEntity() instanceof Mob;
    }

    @Override
    public MapTag getPropertyValue() {
        EntityEquipment equipment = this.getLivingEntity().getEquipment();
        MapTag map = new MapTag();
        map.putObject("head", (ObjectTag)new ElementTag(equipment.getHelmetDropChance()));
        map.putObject("chest", (ObjectTag)new ElementTag(equipment.getChestplateDropChance()));
        map.putObject("legs", (ObjectTag)new ElementTag(equipment.getLeggingsDropChance()));
        map.putObject("feet", (ObjectTag)new ElementTag(equipment.getBootsDropChance()));
        map.putObject("hand", (ObjectTag)new ElementTag(equipment.getItemInMainHandDropChance()));
        map.putObject("off_hand", (ObjectTag)new ElementTag(equipment.getItemInOffHandDropChance()));
        return map;
    }

    @Override
    public void setPropertyValue(MapTag map, Mechanism mechanism) {
        EntityEquipment equipment = this.getLivingEntity().getEquipment();
        ElementTag head = map.getElement("head");
        ElementTag chest = map.getElement("chest");
        ElementTag legs = map.getElement("legs");
        ElementTag feet = map.getElement("feet");
        ElementTag hand = map.getElement("hand");
        ElementTag offHand = map.getElement("off_hand");
        if (head != null) {
            equipment.setHelmetDropChance(head.asFloat());
        }
        if (chest != null) {
            equipment.setChestplateDropChance(chest.asFloat());
        }
        if (legs != null) {
            equipment.setLeggingsDropChance(legs.asFloat());
        }
        if (feet != null) {
            equipment.setBootsDropChance(feet.asFloat());
        }
        if (hand != null) {
            equipment.setItemInMainHandDropChance(hand.asFloat());
        }
        if (offHand != null) {
            equipment.setItemInOffHandDropChance(offHand.asFloat());
        }
    }

    @Override
    public String getPropertyId() {
        return "equipment_drop_chance";
    }

    public static void register() {
        EntityEquipmentDropChance.autoRegister("equipment_drop_chance", EntityEquipmentDropChance.class, MapTag.class, false, new String[0]);
    }
}

