/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.vehicle;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleDamageEvent;

public class VehicleDamagedScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityTag vehicle;
    public EntityTag entity;
    public VehicleDamageEvent event;

    public VehicleDamagedScriptEvent() {
        this.registerCouldMatcher("<vehicle> damaged");
        this.registerCouldMatcher("<entity> damages <vehicle>");
        this.registerSwitches("type");
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!super.couldMatch(path)) {
            return false;
        }
        if (!VehicleDamagedScriptEvent.exactMatchesVehicle(path.eventArgLowerAt(0)) && !VehicleDamagedScriptEvent.exactMatchesVehicle(path.eventArgLowerAt(2))) {
            return false;
        }
        return VehicleDamagedScriptEvent.couldMatchEntity(path.eventArgLowerAt(0));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String ent;
        String cmd = path.eventArgLowerAt(1);
        String veh = cmd.equals("damaged") ? path.eventArgLowerAt(0) : path.eventArgLowerAt(2);
        String string = ent = cmd.equals("damages") ? path.eventArgLowerAt(0) : "";
        if (!this.vehicle.tryAdvancedMatcher(veh, path.context)) {
            return false;
        }
        if (!(ent.isEmpty() || this.entity != null && this.entity.tryAdvancedMatcher(ent, path.context))) {
            return false;
        }
        if (!this.runInCheck(path, this.vehicle.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        ElementTag element;
        if (determinationObj instanceof ElementTag && (element = (ElementTag)determinationObj).isDouble()) {
            this.event.setDamage(element.asDouble());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("vehicle")) {
            return this.vehicle.getDenizenObject();
        }
        if (name.equals("entity") && this.entity != null) {
            return this.entity.getDenizenObject();
        }
        if (name.equals("damage")) {
            return new ElementTag(this.event.getDamage());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onVehicleDestroyed(VehicleDamageEvent event) {
        this.vehicle = new EntityTag((Entity)event.getVehicle());
        this.entity = event.getAttacker() != null ? new EntityTag(event.getAttacker()) : null;
        this.event = event;
        this.fire((Event)event);
    }
}

