/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFromToEvent;

public class LiquidSpreadScriptEvent
extends BukkitScriptEvent
implements Listener {
    public MaterialTag material;
    public LocationTag location;
    public LocationTag destination;
    public BlockFromToEvent event;

    public LiquidSpreadScriptEvent() {
        this.registerCouldMatcher("liquid spreads");
        this.registerSwitches("type");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryObjectSwitch("type", this.material)) {
            return false;
        }
        if (!this.runInCheck(path, this.location) && !this.runInCheck(path, this.destination)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "location" -> this.location;
            case "destination" -> this.destination;
            case "material" -> this.material;
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onLiquidSpreads(BlockFromToEvent event) {
        if (event.getBlock().getType() == Material.DRAGON_EGG) {
            return;
        }
        this.destination = new LocationTag(event.getToBlock().getLocation());
        this.location = new LocationTag(event.getBlock().getLocation());
        this.material = new MaterialTag(event.getBlock());
        this.event = event;
        this.fire((Event)event);
    }
}

