/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.properties.bukkit.BukkitColorExtensions;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.LegacyParticleNaming;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ColorTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Vibration;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PlayEffectCommand
extends AbstractCommand {
    public static final List<Particle> VISIBLE_PARTICLES = new ArrayList<Particle>(Arrays.asList(Particle.values()));

    public PlayEffectCommand() {
        this.setName("playeffect");
        this.setSyntax("playeffect [effect:<name>] [at:<location>|...] (data:<#.#>) (special_data:<map>) (visibility:<#.#>) (quantity:<#>) (offset:<#.#>,<#.#>,<#.#>) (targets:<player>|...) (velocity:<vector>)");
        this.setRequiredArguments(2, 8);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        tab.addWithPrefix("effect:", (Enum<?>[])Particle.values());
        tab.addWithPrefix("effect:", (Enum<?>[])Effect.values());
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentList(LocationTag.class) && (arg.matchesPrefix("at") || !arg.hasPrefix())) {
                if (arg.matchesPrefix("at")) {
                    scriptEntry.addObject("no_offset", new ElementTag(true));
                }
                scriptEntry.addObject("location", arg.asType(ListTag.class).filter(LocationTag.class, scriptEntry));
                continue;
            }
            if (!(scriptEntry.hasObject("effect") || scriptEntry.hasObject("particleeffect") || scriptEntry.hasObject("iconcrack"))) {
                String particleName = CoreUtilities.toUpperCase(arg.getValue());
                Particle particle = Utilities.elementToEnumlike(new ElementTag(particleName), Particle.class);
                if (particle != null) {
                    scriptEntry.addObject("particleeffect", particle);
                    continue;
                }
                particle = LegacyParticleNaming.legacyParticleNames.get(particleName);
                if (particle != null) {
                    BukkitImplDeprecations.oldSpigotNames.warn(scriptEntry);
                    scriptEntry.addObject("particleeffect", particle);
                    continue;
                }
                if (arg.matches("barrier") && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_18)) {
                    scriptEntry.addObject("particleeffect", Particle.BLOCK_MARKER);
                    scriptEntry.addObject("special_data", new ElementTag("barrier"));
                    continue;
                }
                if (arg.matches("random")) {
                    scriptEntry.addObject("particleeffect", VISIBLE_PARTICLES.get(CoreUtilities.getRandom().nextInt(VISIBLE_PARTICLES.size())));
                    continue;
                }
                if (arg.startsWith("iconcrack_")) {
                    BukkitImplDeprecations.oldPlayEffectSpecials.warn(scriptEntry);
                    String shrunk = arg.getValue().substring("iconcrack_".length());
                    ItemTag item = ItemTag.valueOf(shrunk, scriptEntry.context);
                    if (item != null) {
                        scriptEntry.addObject("iconcrack", item);
                        continue;
                    }
                    Debug.echoError("Invalid iconcrack_[item]. Must be a valid ItemTag!");
                    continue;
                }
                if (arg.matchesEnum(Effect.class)) {
                    scriptEntry.addObject("effect", Effect.valueOf((String)arg.getValue().toUpperCase()));
                    continue;
                }
            }
            if (!scriptEntry.hasObject("radius") && arg.matchesFloat() && arg.matchesPrefix("visibility", "v", "radius", "r")) {
                scriptEntry.addObject("radius", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("data") && arg.matchesFloat() && arg.matchesPrefix("data", "d")) {
                scriptEntry.addObject("data", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("special_data") && arg.matchesPrefix("special_data")) {
                scriptEntry.addObject("special_data", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("quantity") && arg.matchesInteger() && arg.matchesPrefix("qty", "q", "quantity")) {
                if (arg.matchesPrefix("q", "qty")) {
                    BukkitImplDeprecations.qtyTags.warn(scriptEntry);
                }
                scriptEntry.addObject("quantity", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("offset") && arg.matchesFloat() && arg.matchesPrefix("offset", "o")) {
                double offset = arg.asElement().asDouble();
                scriptEntry.addObject("offset", new LocationTag(null, offset, offset, offset));
                continue;
            }
            if (!scriptEntry.hasObject("offset") && arg.matchesArgumentType(LocationTag.class) && arg.matchesPrefix("offset", "o")) {
                scriptEntry.addObject("offset", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("velocity") && arg.matchesArgumentType(LocationTag.class) && arg.matchesPrefix("velocity")) {
                scriptEntry.addObject("velocity", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("targets") && arg.matchesArgumentList(PlayerTag.class) && arg.matchesPrefix("targets", "target", "t")) {
                scriptEntry.addObject("targets", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("data", new ElementTag(0));
        scriptEntry.defaultObject("radius", new ElementTag(15));
        scriptEntry.defaultObject("quantity", new ElementTag(1));
        scriptEntry.defaultObject("offset", new LocationTag(null, 0.5, 0.5, 0.5));
        if (!(scriptEntry.hasObject("effect") || scriptEntry.hasObject("particleeffect") || scriptEntry.hasObject("iconcrack"))) {
            throw new InvalidArgumentsException("Missing effect argument!");
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Missing location argument!");
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void execute(ScriptEntry scriptEntry) {
        locations = (List)scriptEntry.getObject("location");
        targets = (List)scriptEntry.getObject("targets");
        effect = (Effect)scriptEntry.getObject("effect");
        particleEffect = (Particle)scriptEntry.getObject("particleeffect");
        iconcrack = (ItemTag)scriptEntry.getObjectTag("iconcrack");
        radius = scriptEntry.getElement("radius");
        data = scriptEntry.getElement("data");
        quantity = scriptEntry.getElement("quantity");
        no_offset = scriptEntry.getElement("no_offset");
        should_offset = no_offset == null || no_offset.asBoolean() == false;
        offset = (LocationTag)scriptEntry.getObjectTag("offset");
        special_data = scriptEntry.getElement("special_data");
        velocity = (LocationTag)scriptEntry.getObjectTag("velocity");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), new Object[]{effect != null ? PlayEffectCommand.db("effect", effect.name()) : (particleEffect != null ? PlayEffectCommand.db("special effect", particleEffect.name()) : iconcrack), PlayEffectCommand.db("locations", locations), PlayEffectCommand.db("targets", targets), radius, data, quantity, offset, special_data, velocity, should_offset != false ? PlayEffectCommand.db("note", "Location will be offset 1 block-height upward (see documentation)") : ""});
        }
        for (LocationTag location : locations) {
            block70: {
                if (should_offset) {
                    location = new LocationTag(location.clone().add(0.0, 1.0, 0.0));
                }
                if (effect != null) {
                    for (n = 0; n < quantity.asInt(); ++n) {
                        if (targets != null) {
                            for (Object player : targets) {
                                if (!player.isValid() || !player.isOnline()) continue;
                                player.getPlayerEntity().playEffect((Location)location, effect, data.asInt());
                            }
                            continue;
                        }
                        location.getWorld().playEffect((Location)location, effect, data.asInt(), radius.asInt());
                    }
                    continue;
                }
                if (particleEffect == null) break block70;
                players = new ArrayList<Player>();
                if (targets == null) {
                    rad = radius.asFloat();
                    player = location.getWorld().getPlayers().iterator();
                    while (player.hasNext()) {
                        player = (Player)player.next();
                        if (!(player.getLocation().distanceSquared((Location)location) < (double)(rad * rad))) continue;
                        players.add(player);
                    }
                } else {
                    for (Object player : targets) {
                        if (!player.isValid() || !player.isOnline()) continue;
                        players.add(player.getPlayerEntity());
                    }
                }
                clazz = particleEffect.getDataType() == Void.class ? null : particleEffect.getDataType();
                dataObject /* !! */  = null;
                if (clazz == null) ** GOTO lbl189
                if (special_data == null) {
                    Debug.echoError("Missing required special data for particle: " + particleEffect.name());
                    return;
                }
                dataMap = MapTag.valueOf(special_data.asString(), scriptEntry.getContext());
                if (dataMap != null) ** GOTO lbl94
                dataList = ListTag.valueOf(special_data.asString(), scriptEntry.getContext());
                BukkitImplDeprecations.playEffectSpecialDataListInput.warn(scriptEntry.getContext());
                if (clazz == Particle.DustOptions.class) {
                    if (dataList.size() != 2) {
                        Debug.echoError("DustOptions special_data must have 2 list entries for particle: " + particleEffect.name());
                        return;
                    }
                    size = Float.parseFloat(dataList.get(0));
                    color = ColorTag.valueOf(dataList.get(1), scriptEntry.context);
                    dataObject /* !! */  = new Particle.DustOptions(BukkitColorExtensions.getColor(color), size);
                } else if (clazz == BlockData.class) {
                    blockMaterial = MaterialTag.valueOf(special_data.asString(), scriptEntry.getContext());
                    dataObject /* !! */  = blockMaterial.getModernData();
                } else if (clazz == ItemStack.class) {
                    itemType = ItemTag.valueOf(special_data.asString(), scriptEntry.getContext());
                    dataObject /* !! */  = itemType.getItemStack();
                } else if (clazz == Particle.DustTransition.class) {
                    if (dataList.size() != 3) {
                        Debug.echoError("DustTransition special_data must have 3 list entries for particle: " + particleEffect.name());
                        return;
                    }
                    size = Float.parseFloat(dataList.get(0));
                    fromColor = ColorTag.valueOf(dataList.get(1), scriptEntry.context);
                    toColor = ColorTag.valueOf(dataList.get(2), scriptEntry.context);
                    dataObject /* !! */  = new Particle.DustTransition(BukkitColorExtensions.getColor(fromColor), BukkitColorExtensions.getColor(toColor), size);
                } else if (clazz == Vibration.class) {
                    if (dataList.size() != 3) {
                        Debug.echoError("Vibration special_data must have 3 list entries for particle: " + particleEffect.name());
                        return;
                    }
                    duration = dataList.getObject(0).asType(DurationTag.class, scriptEntry.context);
                    origin = dataList.getObject(1).asType(LocationTag.class, scriptEntry.context);
                    destination = dataList.getObject(2);
                    destObj /* !! */  = destination.shouldBeType(EntityTag.class) != false ? new Vibration.Destination.EntityDestination(destination.asType(EntityTag.class, scriptEntry.context).getBukkitEntity()) : new Vibration.Destination.BlockDestination((Location)destination.asType(LocationTag.class, scriptEntry.context));
                    dataObject /* !! */  = new Vibration((Location)origin, (Vibration.Destination)destObj /* !! */ , duration.getTicksAsInt());
                } else {
                    Debug.echoError("Unknown particle data type: " + clazz.getCanonicalName() + " for particle: " + particleEffect.name() + ". Are you sure it exists and are not using a legacy format?");
                    return;
lbl94:
                    // 1 sources

                    if (clazz == Particle.DustOptions.class) {
                        size = dataMap.getObjectAs("size", ElementTag.class, scriptEntry.context);
                        if (size == null || !size.isFloat()) {
                            Debug.echoError("special_data input must have a 'size' key with a valid number, for particle " + particleEffect.name());
                            return;
                        }
                        color = dataMap.getObjectAs("color", ColorTag.class, scriptEntry.context);
                        if (color == null) {
                            Debug.echoError("special_data input must have a 'color' key with a valid ColorTag, for particle: " + particleEffect.name());
                            return;
                        }
                        dataObject /* !! */  = new Particle.DustOptions(BukkitColorExtensions.getColor(color), size.asFloat());
                    } else if (clazz == BlockData.class) {
                        blockMaterial = dataMap.getObjectAs("material", MaterialTag.class, scriptEntry.context);
                        if (blockMaterial == null) {
                            Debug.echoError("special_data input must have a 'material' key with a valid MaterialTag, for particle: " + particleEffect.name());
                            return;
                        }
                        dataObject /* !! */  = blockMaterial.getModernData();
                    } else if (clazz == ItemStack.class) {
                        itemType = dataMap.getObjectAs("item", ItemTag.class, scriptEntry.context);
                        if (itemType == null) {
                            Debug.echoError("special_data input must have a 'item' key with a valid ItemTag, for particle: " + particleEffect.name());
                            return;
                        }
                        dataObject /* !! */  = itemType.getItemStack();
                    } else if (clazz == Particle.DustTransition.class) {
                        size = dataMap.getObjectAs("size", ElementTag.class, scriptEntry.context);
                        if (size == null || !size.isFloat()) {
                            Debug.echoError("special_data input must have a 'size' key with a valid number, for particle: " + particleEffect.name());
                            return;
                        }
                        fromColor = dataMap.getObjectAs("from", ColorTag.class, scriptEntry.context);
                        toColor = dataMap.getObjectAs("to", ColorTag.class, scriptEntry.context);
                        if (fromColor == null || toColor == null) {
                            Debug.echoError("special_data input must have a 'to' and 'size' key with a valid ColorTag, for particle: " + particleEffect.name());
                            return;
                        }
                        dataObject /* !! */  = new Particle.DustTransition(BukkitColorExtensions.getColor(fromColor), BukkitColorExtensions.getColor(toColor), size.asFloat());
                    } else if (clazz == Vibration.class) {
                        duration = dataMap.getObjectAs("duration", DurationTag.class, scriptEntry.context);
                        if (duration == null) {
                            Debug.echoError("special_data input must have a 'duration' key with a valid LocationTag, for particle: " + particleEffect.name());
                            return;
                        }
                        origin = dataMap.getObjectAs("origin", LocationTag.class, scriptEntry.context);
                        if (origin == null) {
                            Debug.echoError("special_data input must have a 'origin' key with a valid LocationTag, for particle: " + particleEffect.name());
                            return;
                        }
                        destination = dataMap.getObjectAs("destination", ObjectTag.class, scriptEntry.context);
                        if (destination.shouldBeType(EntityTag.class)) {
                            destObj = new Vibration.Destination.EntityDestination(destination.asType(EntityTag.class, scriptEntry.context).getBukkitEntity());
                        } else if (destination.shouldBeType(LocationTag.class)) {
                            destObj = new Vibration.Destination.BlockDestination((Location)destination.asType(LocationTag.class, scriptEntry.context));
                        } else {
                            Debug.echoError("special_data input must have a 'destination' key with a valid LocationTag or EntityTag, for particle: " + particleEffect.name());
                            return;
                        }
                        dataObject /* !! */  = new Vibration((Location)origin, (Vibration.Destination)destObj, duration.getTicksAsInt());
                    } else if (clazz == Particle.Trail.class) {
                        color = dataMap.getObjectAs("color", ColorTag.class, scriptEntry.context);
                        if (color == null) {
                            Debug.echoError("special_data input must have a 'color' key with a valid ColorTag, for particle: " + particleEffect.name());
                            return;
                        }
                        target = dataMap.getObjectAs("target", LocationTag.class, scriptEntry.context);
                        if (target == null) {
                            Debug.echoError("special_data input must have a 'target' key with a valid LocationTag, for particle: " + particleEffect.name());
                            return;
                        }
                        duration = dataMap.getObjectAs("duration", DurationTag.class, scriptEntry.context);
                        if (duration == null) {
                            Debug.echoError("special_data input must have a 'duration' key with a valid DurationTag, for particle: " + particleEffect.name());
                            return;
                        }
                        dataObject /* !! */  = new Particle.Trail((Location)target, BukkitColorExtensions.getColor(color), duration.getTicksAsInt());
                    } else if (clazz == Color.class) {
                        color = dataMap.getObjectAs("color", ColorTag.class, scriptEntry.context);
                        if (!dataMap.getObject("color").canBeType(ColorTag.class)) {
                            Debug.echoError("special_data input must have a 'color' key with a valid ColorTag, for particle: " + particleEffect.name());
                            return;
                        }
                        dataObject /* !! */  = BukkitColorExtensions.getColor(color);
                    } else if (clazz == Integer.class) {
                        duration = dataMap.getObjectAs("duration", DurationTag.class, scriptEntry.context);
                        if (duration == null) {
                            Debug.echoError("special_data input must have a 'duration' key with a valid DurationTag, for particle: " + particleEffect.name());
                            return;
                        }
                        dataObject /* !! */  = Integer.valueOf(duration.getTicksAsInt());
                    } else if (clazz == Float.class) {
                        radians = dataMap.getObjectAs("radians", ElementTag.class, scriptEntry.context);
                        if (radians == null || !radians.isFloat()) {
                            Debug.echoError("special_data input must have a 'radians' key with a valid number, for particle: " + particleEffect.name());
                            return;
                        }
                        dataObject /* !! */  = Float.valueOf(radians.asFloat());
                    } else {
                        Debug.echoError("Unknown particle data type: " + clazz.getCanonicalName() + " for particle: " + particleEffect.name());
                        return;
lbl189:
                        // 1 sources

                        if (special_data != null) {
                            Debug.echoError("Particles of type '" + particleEffect.name() + "' cannot take special_data as input.");
                            return;
                        }
                    }
                }
                random = CoreUtilities.getRandom();
                quantityInt = quantity.asInt();
                for (Player player : players) {
                    if (velocity == null) {
                        player.spawnParticle(particleEffect, (Location)location, quantityInt, offset.getX(), offset.getY(), offset.getZ(), data.asDouble(), (Object)dataObject /* !! */ );
                        continue;
                    }
                    for (i = 0; i < quantityInt; ++i) {
                        singleLocation = location.clone().add((random.nextDouble() - 0.5) * offset.getX(), (random.nextDouble() - 0.5) * offset.getY(), (random.nextDouble() - 0.5) * offset.getZ());
                        player.spawnParticle(particleEffect, (Location)singleLocation, 0, velocity.getX(), velocity.getY(), velocity.getZ(), 1.0, (Object)dataObject /* !! */ );
                    }
                }
                continue;
            }
            players = new ArrayList<Player>();
            if (targets == null) {
                rad = radius.asFloat();
                for (Player player : location.getWorld().getPlayers()) {
                    if (!(player.getLocation().distanceSquared((Location)location) < (double)(rad * rad))) continue;
                    players.add(player);
                }
            } else {
                for (Object player : targets) {
                    if (!player.isValid() || !player.isOnline()) continue;
                    players.add(player.getPlayerEntity());
                }
            }
            if (iconcrack == null) continue;
            itemStack = iconcrack.getItemStack();
            particle = Particle.valueOf((String)"ITEM_CRACK");
            for (Player player : players) {
                player.spawnParticle(particle, (Location)location, quantity.asInt(), offset.getX(), offset.getY(), offset.getZ(), (double)data.asFloat(), (Object)itemStack);
            }
        }
    }

    static {
        VISIBLE_PARTICLES.removeAll(List.of(Particle.valueOf((String)"SUSPENDED"), Particle.valueOf((String)"SUSPENDED_DEPTH"), Particle.valueOf((String)"WATER_BUBBLE")));
    }
}

