/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockExplodeEvent;

public class BlockExplodesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public BlockExplodeEvent event;
    public List<Block> blocks;
    public LocationTag location;

    public BlockExplodesScriptEvent() {
        this.registerCouldMatcher("<block> explodes");
        this.registerOptionalDetermination(null, ObjectTag.class, (evt, context, value) -> {
            String blocks = value.identify();
            if (blocks.contains(",") || blocks.startsWith("li@")) {
                evt.event.blockList().clear();
                for (LocationTag newBlock : value.asType(ListTag.class, context).filter(LocationTag.class, context)) {
                    if (newBlock.getWorld() != null) {
                        evt.event.blockList().add(newBlock.getBlock());
                        continue;
                    }
                    Debug.echoError("Block input of " + String.valueOf(newBlock) + " does not contain a valid world.");
                }
                return true;
            }
            if (value.asElement().isFloat()) {
                BukkitImplDeprecations.blockExplodesStrengthDetermination.warn();
                evt.event.setYield(value.asElement().asFloat());
                return true;
            }
            return false;
        });
        this.registerOptionalDetermination("strength", ElementTag.class, (evt, context, value) -> {
            if (value.isFloat()) {
                evt.event.setYield(value.asFloat());
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryArgObject(0, this.location)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "block" -> this.location;
            case "blocks" -> new ListTag(this.blocks, block -> new LocationTag(block.getLocation()));
            case "strength" -> new ElementTag(this.event.getYield());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onBlockExplodes(BlockExplodeEvent event) {
        this.blocks = event.blockList();
        this.event = event;
        this.location = new LocationTag(event.getBlock().getLocation());
        this.fire((Event)event);
    }
}

