/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.impl;

import com.denizenscript.denizen.nms.abstracts.ImprovedOfflinePlayer;
import com.denizenscript.denizen.nms.v1_20.helpers.NBTAdapter;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.shaded.net.adventure.nbt.BinaryTagTypes;
import com.denizenscript.shaded.net.adventure.nbt.CompoundBinaryTag;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeDefaults;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.InventoryEnderChest;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R4.CraftRegistry;
import org.bukkit.craftbukkit.v1_20_R4.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_20_R4.inventory.CraftInventoryPlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class ImprovedOfflinePlayerImpl
extends ImprovedOfflinePlayer {
    public ImprovedOfflinePlayerImpl(UUID playeruuid) {
        super(playeruuid);
    }

    @Override
    public org.bukkit.inventory.PlayerInventory getInventory() {
        if (this.inventory == null) {
            OfflinePlayerInventory newInv = new OfflinePlayerInventory(null);
            newInv.b(NBTAdapter.toNMS(this.compound.getList("Inventory", BinaryTagTypes.COMPOUND)));
            this.inventory = new OfflineCraftInventoryPlayer(newInv);
        }
        return this.inventory;
    }

    @Override
    public void setInventory(org.bukkit.inventory.PlayerInventory inventory) {
        CraftInventoryPlayer inv = (CraftInventoryPlayer)inventory;
        this.compound = (CompoundBinaryTag)this.compound.put("Inventory", NBTAdapter.toAPI(inv.getInventory().a(new NBTTagList())));
        this.markModified();
    }

    @Override
    public Inventory getEnderChest() {
        if (this.enderchest == null) {
            InventoryEnderChest endchest = new InventoryEnderChest(null);
            endchest.a(NBTAdapter.toNMS(this.compound.getList("EnderItems", BinaryTagTypes.COMPOUND)), (HolderLookup.a)CraftRegistry.getMinecraftRegistry());
            this.enderchest = new CraftInventory((IInventory)endchest);
        }
        return this.enderchest;
    }

    @Override
    public void setEnderChest(Inventory inventory) {
        this.compound = (CompoundBinaryTag)this.compound.put("EnderItems", NBTAdapter.toAPI(((InventoryEnderChest)((CraftInventory)inventory).getInventory()).a((HolderLookup.a)CraftRegistry.getMinecraftRegistry())));
        this.markModified();
    }

    @Override
    public double getMaxHealth() {
        AttributeModifiable maxHealth = this.getAttributes().a(GenericAttributes.q);
        return maxHealth == null ? ((AttributeBase)GenericAttributes.q.a()).a() : maxHealth.f();
    }

    @Override
    public void setMaxHealth(double input) {
        AttributeMapBase attributes = this.getAttributes();
        AttributeModifiable maxHealth = attributes.a(GenericAttributes.q);
        maxHealth.a(input);
        this.setAttributes(attributes);
    }

    private AttributeMapBase getAttributes() {
        AttributeMapBase amb = new AttributeMapBase(AttributeDefaults.a((EntityTypes)EntityTypes.by));
        amb.a(NBTAdapter.toNMS(this.compound.getList("Attributes", BinaryTagTypes.COMPOUND)));
        return amb;
    }

    public void setAttributes(AttributeMapBase attributes) {
        this.compound = (CompoundBinaryTag)this.compound.put("Attributes", NBTAdapter.toAPI(attributes.c()));
        this.markModified();
    }

    @Override
    protected boolean loadPlayerData(UUID uuid) {
        try {
            this.player = uuid;
            for (World w : Bukkit.getWorlds()) {
                this.file = new File(w.getWorldFolder(), "playerdata" + File.separator + String.valueOf(this.player) + ".dat");
                if (!this.file.exists()) continue;
                this.compound = NBTAdapter.toAPI(NBTCompressedStreamTools.a((InputStream)new FileInputStream(this.file), (NBTReadLimiter)NBTReadLimiter.a()));
                return true;
            }
        }
        catch (Exception e2) {
            Debug.echoError(e2);
        }
        return false;
    }

    @Override
    public void saveInternal(CompoundBinaryTag compound) {
        try {
            NBTCompressedStreamTools.a((NBTTagCompound)NBTAdapter.toNMS(compound), (OutputStream)new FileOutputStream(this.file));
        }
        catch (Exception e2) {
            Debug.echoError(e2);
        }
    }

    public static class OfflinePlayerInventory
    extends PlayerInventory {
        public OfflinePlayerInventory(EntityHuman entityhuman) {
            super(entityhuman);
        }

        public InventoryHolder getOwner() {
            return null;
        }
    }

    public static class OfflineCraftInventoryPlayer
    extends CraftInventoryPlayer {
        public OfflineCraftInventoryPlayer(PlayerInventory inventory) {
            super(inventory);
        }

        public HumanEntity getHolder() {
            return null;
        }
    }
}

