/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Map;

public class DefineMapCommand
extends AbstractCommand {
    public DefineMapCommand() {
        this.setName("definemap");
        this.setSyntax("definemap [<name>] [<key>:<value> ...]");
        this.setRequiredArguments(1, -1);
        this.isProcedural = true;
        this.allowedDynamicPrefixes = true;
        this.anyPrefixSymbolAllowed = true;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        MapTag value = new MapTag();
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("definition") && !arg.hasPrefix()) {
                scriptEntry.addObject("definition", new ElementTag(CoreUtilities.toLowerCase(arg.getValue())));
                continue;
            }
            if (arg.hasPrefix()) {
                value.putObject(arg.getPrefix().getRawValue(), arg.object);
                continue;
            }
            if (!arg.hasPrefix() && arg.getRawValue().contains(":")) {
                int colon = arg.getRawValue().indexOf(58);
                value.putObject(arg.getRawValue().substring(0, colon), (ObjectTag)new ElementTag(arg.getRawValue().substring(colon + 1)));
                continue;
            }
            arg.reportUnhandled();
        }
        if (scriptEntry.internal.yamlSubcontent instanceof Map) {
            MapTag map = (MapTag)CoreUtilities.objectToTagForm(scriptEntry.internal.yamlSubcontent, scriptEntry.getContext(), true, true);
            value.putAll(map);
        }
        scriptEntry.addObject("map", value);
        if (!scriptEntry.hasObject("definition") || !scriptEntry.hasObject("map")) {
            throw new InvalidArgumentsException("Must specify a definition and value!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag definition = scriptEntry.getElement("definition");
        MapTag value = (MapTag)scriptEntry.getObjectTag("map");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), new QueueTag(scriptEntry.getResidingQueue()), definition, value);
        }
        scriptEntry.getResidingQueue().addDefinition(definition.asString(), value.duplicate());
    }
}

