/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import io.papermc.paper.event.player.PlayerTrackEntityEvent;
import io.papermc.paper.event.player.PlayerUntrackEntityEvent;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PlayerTracksEntityScriptEvent
extends BukkitScriptEvent
implements Listener {
    public String type;
    public Player player;
    public EntityTag entity;

    public PlayerTracksEntityScriptEvent() {
        this.registerCouldMatcher("player tracks|untracks <entity>");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.eventArgLowerAt(1).equals(this.type)) {
            return false;
        }
        if (!path.tryArgObject(2, this.entity)) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.player);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "entity" -> this.entity;
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onPlayerTracksEntityEvent(PlayerTrackEntityEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.player = event.getPlayer();
        this.type = "tracks";
        this.fire((Event)event);
    }

    @EventHandler
    public void onPlayerUntracksEntityEvent(PlayerUntrackEntityEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.player = event.getPlayer();
        this.type = "untracks";
        EntityTag.rememberEntity(event.getEntity());
        this.fire((Event)event);
        EntityTag.forgetEntity(event.getEntity());
    }
}

