/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities;

import com.denizenscript.denizencore.utilities.AsciiMatcher;
import java.util.HashMap;

public class TextWidthHelper {
    public static int[] asciiWidthMap = new int[128];
    public static HashMap<Character, Integer> characterWidthMap = new HashMap();
    public static AsciiMatcher formatCharCodeMatcher;

    public static void setWidth(int width, String chars) {
        for (char c : chars.toCharArray()) {
            if (c < '\u0080') {
                TextWidthHelper.asciiWidthMap[c] = width;
                continue;
            }
            characterWidthMap.put(Character.valueOf(c), width);
        }
    }

    public static int getWidth(char c) {
        if (c < '\u0080') {
            return asciiWidthMap[c];
        }
        return characterWidthMap.getOrDefault(Character.valueOf(c), 6);
    }

    public static int getWidth(String str) {
        return TextWidthHelper.getWidth(false, str);
    }

    public static int getWidth(boolean wasBold, String str) {
        int maxWidth = 0;
        int total = 0;
        boolean bold = wasBold;
        char[] rawChars = str.toCharArray();
        for (int i = 0; i < rawChars.length; ++i) {
            char c = rawChars[i];
            if (c == '\u00a7' && i + 1 < rawChars.length) {
                char c2 = rawChars[i + 1];
                if (c2 == '[') {
                    while (i < rawChars.length && rawChars[i] != ']') {
                        ++i;
                    }
                    continue;
                }
                if (c2 == 'l' || c2 == 'L') {
                    bold = true;
                } else if (!formatCharCodeMatcher.isMatch(c2)) {
                    bold = false;
                }
                ++i;
                continue;
            }
            total += TextWidthHelper.getWidth(c) + (bold ? 1 : 0);
            if (c != '\n') continue;
            if (total > maxWidth) {
                maxWidth = total;
            }
            total = 0;
        }
        return Math.max(total, maxWidth);
    }

    public static boolean isBold(boolean wasBold, String str) {
        boolean bold = wasBold;
        char[] rawChars = str.toCharArray();
        for (int i = 0; i < rawChars.length; ++i) {
            char c = rawChars[i];
            if (c != '\u00a7' || i + 1 >= rawChars.length) continue;
            char c2 = rawChars[i + 1];
            if (c2 == 'l' || c2 == 'L') {
                bold = true;
                continue;
            }
            if (formatCharCodeMatcher.isMatch(c2)) continue;
            bold = false;
        }
        return bold;
    }

    public static String splitLines(String str, int width) {
        if (width < 8) {
            return str;
        }
        StringBuilder output = new StringBuilder(str.length() * 2);
        int lineStart = 0;
        boolean bold = false;
        block0: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\u00a7') {
                ++i;
                continue;
            }
            if (c == '\n') {
                String lastLine = str.substring(lineStart, i + 1);
                bold = TextWidthHelper.isBold(bold, lastLine);
                output.append(lastLine);
                lineStart = i + 1;
                continue;
            }
            if (TextWidthHelper.getWidth(bold, str.substring(lineStart, i)) <= width) continue;
            for (int x = i - 1; x > lineStart; --x) {
                char xc = str.charAt(x);
                if (xc != ' ') continue;
                String lastLine = str.substring(lineStart, x);
                bold = TextWidthHelper.isBold(bold, lastLine);
                output.append(lastLine).append("\n");
                lineStart = x + 1;
                i = x;
                continue block0;
            }
            String lastLine = str.substring(lineStart, i);
            bold = TextWidthHelper.isBold(bold, lastLine);
            output.append(lastLine).append("\n");
            lineStart = i;
        }
        output.append(str, lineStart, str.length());
        return output.toString();
    }

    static {
        for (int i = 0; i < 128; ++i) {
            TextWidthHelper.asciiWidthMap[i] = 6;
        }
        TextWidthHelper.setWidth(2, "!,.:;|i'");
        TextWidthHelper.setWidth(3, "l`");
        TextWidthHelper.setWidth(4, " (){}[]tI\"*");
        TextWidthHelper.setWidth(5, "<>fk\u00aa\u00ba\u258c\u2321\u00b0\u207f\u00b2");
        TextWidthHelper.setWidth(7, "@~\u00ab\u00bb\u2261\u2248\u221a");
        TextWidthHelper.setWidth(8, "\u2591\u2562\u2556\u2563\u2551\u2557\u255d\u255c\u2205\u2320");
        TextWidthHelper.setWidth(9, "\u2592\u2593\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u250c\u2588\u2584\u2590\u2580");
        formatCharCodeMatcher = new AsciiMatcher("klmnoKLMNO");
    }
}

