/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.impl.blocks;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BlockLight;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.utilities.blocks.ChunkCoordinate;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutLightUpdate;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.lighting.LightEngineLayerEventListener;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R7.CraftChunk;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class BlockLightImpl
extends BlockLight {
    public static final Class LIGHTENGINETHREADED_TASKTYPE = Arrays.stream(LightEngineThreaded.class.getDeclaredClasses()).filter(c2 -> c2.isEnum()).findFirst().get();
    public static final Object LIGHTENGINETHREADED_TASKTYPE_PRE;
    public static final MethodHandle LIGHTENGINETHREADED_QUEUERUNNABLE;
    public static boolean doNotCheck;
    public static final Vector[] RELATIVE_CHUNKS;

    public static void enqueueRunnable(Chunk chunk, Runnable runnable) {
        LevelLightEngine lightEngine = chunk.I().ac().r();
        if (lightEngine instanceof LightEngineThreaded) {
            ChunkCoordIntPair coord = chunk.f();
            try {
                LIGHTENGINETHREADED_QUEUERUNNABLE.invoke(lightEngine, coord.h, coord.i, LIGHTENGINETHREADED_TASKTYPE_PRE, runnable);
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
        } else {
            runnable.run();
        }
    }

    private BlockLightImpl(Location location, long ticks) {
        super(location, ticks);
    }

    public static BlockLight createLight(Location location, int lightLevel, long ticks) {
        BlockLight blockLight;
        if (lightsByLocation.containsKey(location = location.getBlock().getLocation())) {
            blockLight = (BlockLight)lightsByLocation.get(location);
            if (blockLight.removeTask != null) {
                blockLight.removeTask.cancel();
                blockLight.removeTask = null;
            }
            if (blockLight.updateTask != null) {
                blockLight.updateTask.cancel();
                blockLight.updateTask = null;
            }
            blockLight.removeLater(ticks);
        } else {
            blockLight = new BlockLightImpl(location, ticks);
            lightsByLocation.put(location, blockLight);
            if (!lightsByChunk.containsKey(blockLight.chunkCoord)) {
                lightsByChunk.put(blockLight.chunkCoord, new ArrayList());
            }
            ((List)lightsByChunk.get(blockLight.chunkCoord)).add(blockLight);
        }
        blockLight.intendedLevel = lightLevel;
        blockLight.update(lightLevel, true);
        return blockLight;
    }

    public static void checkIfLightsBrokenByPacket(PacketPlayOutBlockChange packet, World world) {
        try {
            BlockPosition pos = packet.e();
            int chunkX = pos.u() >> 4;
            int chunkZ = pos.w() >> 4;
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)NMSHandler.getJavaPlugin(), () -> {
                Chunk chunk = world.d(chunkX, chunkZ);
                boolean any = false;
                for (Vector vec : RELATIVE_CHUNKS) {
                    List lights;
                    IChunkAccess other = world.a(chunkX + vec.getBlockX(), chunkZ + vec.getBlockZ(), ChunkStatus.n, false);
                    if (!(other instanceof Chunk) || (lights = (List)lightsByChunk.get(new ChunkCoordinate((org.bukkit.Chunk)new CraftChunk((Chunk)other)))) == null) continue;
                    any = true;
                    for (BlockLight light : lights) {
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)NMSHandler.getJavaPlugin(), () -> light.update(light.intendedLevel, false), 1L);
                    }
                }
                if (any) {
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)NMSHandler.getJavaPlugin(), () -> BlockLightImpl.sendNearbyChunkUpdates(chunk), 3L);
                }
            }, 1L);
        }
        catch (Exception ex) {
            Debug.echoError(ex);
        }
    }

    public static void checkIfLightsBrokenByPacket(PacketPlayOutLightUpdate packet, World world) {
        if (doNotCheck) {
            return;
        }
        try {
            int cX = packet.b();
            int cZ = packet.e();
            BitSet bitMask = packet.f().d();
            List blockData = packet.f().f();
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)NMSHandler.getJavaPlugin(), () -> {
                IChunkAccess chk = world.a(cX, cZ, ChunkStatus.n, false);
                if (!(chk instanceof Chunk)) {
                    return;
                }
                List lights = (List)lightsByChunk.get(new ChunkCoordinate((org.bukkit.Chunk)new CraftChunk((Chunk)chk)));
                if (lights == null) {
                    return;
                }
                boolean any = false;
                for (BlockLight light : lights) {
                    if (!((BlockLightImpl)light).checkIfChangedBy(bitMask, blockData)) continue;
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)NMSHandler.getJavaPlugin(), () -> light.update(light.intendedLevel, false), 1L);
                    any = true;
                }
                if (any) {
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)NMSHandler.getJavaPlugin(), () -> BlockLightImpl.sendNearbyChunkUpdates((Chunk)chk), 3L);
                }
            }, 1L);
        }
        catch (Exception ex) {
            Debug.echoError(ex);
        }
    }

    public boolean checkIfChangedBy(BitSet bitmask, List<byte[]> data) {
        Location blockLoc = this.block.getLocation();
        int layer = (blockLoc.getBlockY() >> 4) + 1;
        if (!bitmask.get(layer)) {
            return false;
        }
        int found = 0;
        for (int i = 0; i < 16; ++i) {
            if (!bitmask.get(i)) continue;
            if (i == layer) {
                int z;
                int y;
                int x;
                byte[] blocks = data.get(found);
                NibbleArray arr = new NibbleArray(blocks);
                int level = arr.a(x = blockLoc.getBlockX() - (this.chunkCoord.x << 4), y = blockLoc.getBlockY() % 16, z = blockLoc.getBlockZ() - (this.chunkCoord.z << 4));
                return this.intendedLevel != level;
            }
            ++found;
        }
        return false;
    }

    public static void runResetFor(Chunk chunk, BlockPosition pos) {
        Runnable runnable = () -> {
            LevelLightEngine lightEngine = chunk.I().ac().r();
            LightEngineLayerEventListener engineBlock = lightEngine.a(EnumSkyBlock.b);
            engineBlock.a(pos);
        };
        BlockLightImpl.enqueueRunnable(chunk, runnable);
    }

    public static void runSetFor(Chunk chunk, BlockPosition pos, int level) {
        Runnable runnable = () -> {
            LevelLightEngine lightEngine = chunk.I().ac().r();
            LightEngineLayerEventListener engineBlock = lightEngine.a(EnumSkyBlock.b);
        };
        BlockLightImpl.enqueueRunnable(chunk, runnable);
    }

    @Override
    public void reset(boolean updateChunk) {
        BlockLightImpl.runResetFor((Chunk)((CraftChunk)this.getChunk()).getHandle(ChunkStatus.n), ((CraftBlock)this.block).getPosition());
        if (updateChunk) {
            this.updateTask = Bukkit.getScheduler().runTaskLater((Plugin)NMSHandler.getJavaPlugin(), this::sendNearbyChunkUpdates, 1L);
        }
    }

    @Override
    public void update(int lightLevel, boolean updateChunk) {
        BlockLightImpl.runResetFor((Chunk)((CraftChunk)this.getChunk()).getHandle(ChunkStatus.n), ((CraftBlock)this.block).getPosition());
        this.updateTask = Bukkit.getScheduler().runTaskLater((Plugin)NMSHandler.getJavaPlugin(), () -> {
            this.updateTask = null;
            BlockLightImpl.runSetFor((Chunk)((CraftChunk)this.chunk).getHandle(ChunkStatus.n), ((CraftBlock)this.block).getPosition(), lightLevel);
            if (updateChunk) {
                this.updateTask = Bukkit.getScheduler().runTaskLater((Plugin)NMSHandler.getJavaPlugin(), this::sendNearbyChunkUpdates, 1L);
            }
        }, 1L);
    }

    public void sendNearbyChunkUpdates() {
        BlockLightImpl.sendNearbyChunkUpdates((Chunk)((CraftChunk)this.getChunk()).getHandle(ChunkStatus.n));
    }

    public static void sendNearbyChunkUpdates(Chunk chunk) {
        ChunkCoordIntPair pos = chunk.f();
        for (Vector vec : RELATIVE_CHUNKS) {
            IChunkAccess other = chunk.I().a(pos.h + vec.getBlockX(), pos.i + vec.getBlockZ(), ChunkStatus.n, false);
            if (!(other instanceof Chunk)) continue;
            BlockLightImpl.sendSingleChunkUpdate((Chunk)other);
        }
    }

    public static void sendSingleChunkUpdate(Chunk chunk) {
    }

    static {
        Object preObj = null;
        try {
            preObj = ReflectionHelper.getFields(LIGHTENGINETHREADED_TASKTYPE).get(ReflectionMappingsInfo.ThreadedLevelLightEngineTaskType_PRE_UPDATE).get(null);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        LIGHTENGINETHREADED_TASKTYPE_PRE = preObj;
        LIGHTENGINETHREADED_QUEUERUNNABLE = ReflectionHelper.getMethodHandle(LightEngineThreaded.class, ReflectionMappingsInfo.ThreadedLevelLightEngine_addTask_method, Integer.TYPE, Integer.TYPE, LIGHTENGINETHREADED_TASKTYPE, Runnable.class);
        doNotCheck = false;
        RELATIVE_CHUNKS = new Vector[]{new Vector(0, 0, 0), new Vector(-1, 0, 0), new Vector(1, 0, 0), new Vector(0, 0, -1), new Vector(0, 0, 1), new Vector(-1, 0, -1), new Vector(-1, 0, 1), new Vector(1, 0, -1), new Vector(1, 0, 1)};
    }
}

