/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;

public class EntityCombustsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityTag entity;
    public EntityCombustEvent event;

    public EntityCombustsScriptEvent() {
        this.registerCouldMatcher("<entity> combusts");
        this.registerOptionalDetermination(null, ObjectTag.class, (evt, context, determination) -> {
            ElementTag element;
            if (determination instanceof ElementTag && (element = (ElementTag)determination).isInt()) {
                evt.event.setDuration(element.asInt());
                return true;
            }
            if (determination.canBeType(DurationTag.class)) {
                evt.event.setDuration(determination.asType(DurationTag.class, context).getSecondsAsInt());
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryArgObject(0, this.entity)) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "entity" -> this.entity.getDenizenObject();
            case "duration" -> new DurationTag(this.event.getDuration());
            case "source" -> {
                EntityCombustByBlockEvent byBlockEvent;
                Block combuster;
                EntityCombustEvent var6_4 = this.event;
                if (var6_4 instanceof EntityCombustByEntityEvent) {
                    EntityCombustByEntityEvent byEntityEvent = (EntityCombustByEntityEvent)var6_4;
                    yield new EntityTag(byEntityEvent.getCombuster()).getDenizenObject();
                }
                var6_4 = this.event;
                if (var6_4 instanceof EntityCombustByBlockEvent && (combuster = (byBlockEvent = (EntityCombustByBlockEvent)var6_4).getCombuster()) != null) {
                    yield new LocationTag(combuster.getLocation());
                }
                yield null;
            }
            case "source_type" -> new ElementTag(this.event instanceof EntityCombustByEntityEvent ? "ENTITY" : (this.event instanceof EntityCombustByBlockEvent ? "LOCATION" : "NONE"));
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onEntityCombusts(EntityCombustEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.event = event;
        this.fire((Event)event);
    }
}

