/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.destroystokyo.paper.SkinParts;
import com.destroystokyo.paper.event.player.PlayerClientOptionsChangeEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PlayerClientOptionsChangeScriptEvent
extends BukkitScriptEvent
implements Listener {
    public PlayerClientOptionsChangeEvent event;

    public PlayerClientOptionsChangeScriptEvent() {
        this.registerCouldMatcher("player client options change");
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    public ObjectTag getContext(String name) {
        return switch (name) {
            case "server_listings_enabled" -> {
                if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19)) {
                    yield new ElementTag(this.event.allowsServerListings());
                }
                yield null;
            }
            case "chat_visibility" -> new ElementTag((Enum)this.event.getChatVisibility());
            case "locale" -> new ElementTag(this.event.getLocale());
            case "main_hand" -> new ElementTag((Enum)this.event.getMainHand());
            case "skin_parts" -> {
                MapTag map = new MapTag();
                SkinParts skinParts = this.event.getSkinParts();
                map.putObject("cape", (ObjectTag)new ElementTag(skinParts.hasCapeEnabled()));
                map.putObject("jacket", (ObjectTag)new ElementTag(skinParts.hasJacketEnabled()));
                map.putObject("left_sleeve", (ObjectTag)new ElementTag(skinParts.hasLeftSleeveEnabled()));
                map.putObject("right_sleeve", (ObjectTag)new ElementTag(skinParts.hasRightSleeveEnabled()));
                map.putObject("left_pants", (ObjectTag)new ElementTag(skinParts.hasLeftPantsEnabled()));
                map.putObject("right_pants", (ObjectTag)new ElementTag(skinParts.hasRightPantsEnabled()));
                map.putObject("hat", (ObjectTag)new ElementTag(skinParts.hasHatsEnabled()));
                yield map;
            }
            case "view_distance" -> new ElementTag(this.event.getViewDistance());
            case "server_listings_changed" -> {
                if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19)) {
                    yield new ElementTag(this.event.hasAllowServerListingsChanged());
                }
                yield null;
            }
            case "chat_colors_enabled" -> new ElementTag(this.event.hasChatColorsEnabled());
            case "chat_colors_changed" -> new ElementTag(this.event.hasChatColorsEnabledChanged());
            case "chat_visibility_changed" -> {
                if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19)) {
                    yield new ElementTag(this.event.hasChatVisibilityChanged());
                }
                yield null;
            }
            case "locale_changed" -> new ElementTag(this.event.hasLocaleChanged());
            case "main_hand_changed" -> new ElementTag(this.event.hasMainHandChanged());
            case "skin_parts_changed" -> new ElementTag(this.event.hasSkinPartsChanged());
            case "text_filtering_changed" -> {
                if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19)) {
                    yield new ElementTag(this.event.hasTextFilteringChanged());
                }
                yield null;
            }
            case "text_filtering_enabled" -> {
                if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19)) {
                    yield new ElementTag(this.event.hasTextFilteringEnabled());
                }
                yield null;
            }
            case "view_distance_changed" -> new ElementTag(this.event.hasViewDistanceChanged());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onPlayerClientOptionsChange(PlayerClientOptionsChangeEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

