/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.properties;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import io.papermc.paper.math.Position;
import java.util.Collection;
import org.bukkit.boss.DragonBattle;

public class PaperWorldExtensions {
    public static void register() {
        WorldTag.tagProcessor.registerTag(ElementTag.class, "no_tick_view_distance", (attribute, world) -> {
            BukkitImplDeprecations.paperNoTickViewDistance.warn(attribute.context);
            return new ElementTag(world.getWorld().getNoTickViewDistance());
        }, new String[0]);
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20)) {
            WorldTag.tagProcessor.registerTag(ElementTag.class, "gateway_count", (attribute, object) -> {
                DragonBattle battle = object.getWorld().getEnderDragonBattle();
                if (battle == null) {
                    attribute.echoError("Provided world is not an end world!");
                    return null;
                }
                return new ElementTag(battle.getGatewayCount());
            }, new String[0]);
            WorldTag.tagProcessor.registerTag(ListTag.class, "healing_crystals", (attribute, object) -> {
                DragonBattle battle = object.getWorld().getEnderDragonBattle();
                if (battle == null) {
                    attribute.echoError("Provided world is not an end world!");
                    return null;
                }
                return new ListTag((Collection)battle.getHealingCrystals(), EntityTag::new);
            }, new String[0]);
            WorldTag.tagProcessor.registerTag(ListTag.class, "respawn_crystals", (attribute, object) -> {
                DragonBattle battle = object.getWorld().getEnderDragonBattle();
                if (battle == null) {
                    attribute.echoError("Provided world is not an end world!");
                    return null;
                }
                return new ListTag((Collection)battle.getRespawnCrystals(), EntityTag::new);
            }, new String[0]);
            WorldTag.tagProcessor.registerMechanism("spawn_gateway", false, (object, mechanism) -> {
                DragonBattle battle = object.getWorld().getEnderDragonBattle();
                if (battle == null) {
                    mechanism.echoError("Cannot spawn gateway in non-end world!");
                    return;
                }
                if (!mechanism.hasValue()) {
                    battle.spawnNewGateway();
                } else if (mechanism.requireObject(LocationTag.class)) {
                    battle.spawnNewGateway((Position)mechanism.valueAsType(LocationTag.class));
                }
            }, new String[0]);
        }
        WorldTag.tagProcessor.registerMechanism("view_distance", false, ElementTag.class, (object, mechanism, input) -> {
            if (mechanism.requireInteger()) {
                int distance = input.asInt();
                if (distance < 2 || distance > 32) {
                    mechanism.echoError("View distance must be a number from 2 to 32!");
                } else {
                    object.getWorld().setViewDistance(distance);
                }
            }
        }, new String[0]);
        WorldTag.tagProcessor.registerMechanism("simulation_distance", false, ElementTag.class, (object, mechanism, input) -> {
            if (mechanism.requireInteger()) {
                int distance = input.asInt();
                if (distance < 2 || distance > 32) {
                    mechanism.echoError("View distance must be a number from 2 to 32!");
                } else {
                    object.getWorld().setSimulationDistance(distance);
                }
            }
        }, new String[0]);
        WorldTag.tagProcessor.registerMechanism("no_tick_view_distance", false, (object, mechanism) -> {
            BukkitImplDeprecations.paperNoTickViewDistance.warn(mechanism.context);
            if (!mechanism.hasValue()) {
                object.getWorld().setNoTickViewDistance(-1);
            } else if (mechanism.requireInteger()) {
                int distance = mechanism.getValue().asInt();
                if (distance < 2 || distance > 32) {
                    mechanism.echoError("View distance must be a number from 2 to 32!");
                } else {
                    object.getWorld().setNoTickViewDistance(distance);
                }
            }
        }, new String[0]);
    }
}

