/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.tags.core;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.npc.traits.AssignmentTrait;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.HashMap;
import java.util.Map;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.TeleportStuckAction;
import net.citizensnpcs.api.ai.event.NavigationBeginEvent;
import net.citizensnpcs.api.ai.event.NavigationCancelEvent;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.ai.event.NavigationStuckEvent;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class NPCTagBase
implements Listener {
    public static Map<Integer, LocationTag> previousLocations = new HashMap<Integer, LocationTag>();

    public NPCTagBase() {
        if (Depends.citizens != null) {
            Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)Denizen.getInstance());
            TagManager.registerTagHandler(NPCTag.class, "npc", attribute -> {
                if (!attribute.hasParam()) {
                    NPCTag npc = ((BukkitTagContext)attribute.context).npc;
                    if (npc != null) {
                        return npc;
                    }
                    attribute.echoError("Missing NPC for npc tag.");
                    return null;
                }
                return NPCTag.valueOf(attribute.getParam(), attribute.context);
            });
        }
    }

    @EventHandler
    public void navComplete(NavigationCompleteEvent event) {
        if (!event.getNPC().hasTrait(AssignmentTrait.class)) {
            return;
        }
        NPCTag npc = new NPCTag(event.getNPC());
        npc.action("complete navigation", null);
    }

    @EventHandler
    public void navBegin(NavigationBeginEvent event) {
        if (!event.getNPC().hasTrait(AssignmentTrait.class)) {
            return;
        }
        NPCTag npc = new NPCTag(event.getNPC());
        npc.action("begin navigation", null);
        if (event.getNPC().getNavigator().getTargetType() == TargetType.ENTITY) {
            LivingEntity entity = (LivingEntity)event.getNPC().getNavigator().getEntityTarget().getTarget();
            if (event.getNPC().getNavigator().getEntityTarget().isAggressive() && !entity.isDead()) {
                PlayerTag player = null;
                if (entity instanceof Player) {
                    player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)((Player)entity));
                }
                npc.action("attack", player);
                npc.action("attack on " + String.valueOf(entity.getType()), player);
            }
            previousLocations.put(event.getNPC().getId(), npc.getLocation());
        }
    }

    @EventHandler
    public void navCancel(NavigationCancelEvent event) {
        if (!event.getNPC().hasTrait(AssignmentTrait.class)) {
            return;
        }
        NPCTag npc = new NPCTag(event.getNPC());
        npc.action("cancel navigation", null);
        npc.action("cancel navigation due to " + event.getCancelReason().toString(), null);
    }

    @EventHandler
    public void navStuck(NavigationStuckEvent event) {
        if (!event.getNPC().hasTrait(AssignmentTrait.class)) {
            return;
        }
        NPCTag npc = new NPCTag(event.getNPC());
        HashMap<String, ObjectTag> context = new HashMap<String, ObjectTag>();
        context.put("action", new ElementTag(event.getAction() == TeleportStuckAction.INSTANCE ? "teleport" : "none"));
        ListTag determination = npc.action("stuck", null, context);
        if (determination.containsCaseInsensitive("none")) {
            event.setAction(null);
        }
        if (determination.containsCaseInsensitive("teleport")) {
            event.setAction((StuckAction)TeleportStuckAction.INSTANCE);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDeath(EntityDeathEvent deathEvent) {
        NPC citizen = CitizensAPI.getNPCRegistry().getNPC((Entity)deathEvent.getEntity());
        if (citizen == null || !citizen.hasTrait(AssignmentTrait.class)) {
            return;
        }
        NPCTag npc = new NPCTag(citizen);
        EntityDamageEvent event = deathEvent.getEntity().getLastDamageCause();
        String deathCause = event == null ? "unknown" : CoreUtilities.toLowerCase(event.getCause().toString()).replace('_', ' ');
        HashMap<String, ObjectTag> context = new HashMap<String, ObjectTag>();
        context.put("damage", new ElementTag(event == null ? 0.0 : event.getDamage()));
        context.put("death_cause", new ElementTag(deathCause));
        PlayerTag player = null;
        if (event instanceof EntityDamageByEntityEvent) {
            ProjectileSource shooter;
            Entity killerEntity = ((EntityDamageByEntityEvent)event).getDamager();
            context.put("killer", new EntityTag(killerEntity).getDenizenObject());
            if (killerEntity instanceof Player) {
                player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)((Player)killerEntity));
            } else if (killerEntity instanceof Projectile && (shooter = ((Projectile)killerEntity).getShooter()) instanceof LivingEntity) {
                context.put("shooter", new EntityTag((Entity)((LivingEntity)shooter)).getDenizenObject());
                if (shooter instanceof Player) {
                    player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)((Player)shooter));
                }
                npc.action("death by " + String.valueOf(((LivingEntity)shooter).getType()), player, context);
            }
            npc.action("death by entity", player, context);
            npc.action("death by " + String.valueOf(killerEntity.getType()), player, context);
        } else if (event instanceof EntityDamageByBlockEvent) {
            npc.action("death by block", null, context);
        }
        npc.action("death", player, context);
        npc.action("death by " + deathCause, player, context);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onHit(EntityDamageByEntityEvent event) {
        NPC citizen = CitizensAPI.getNPCRegistry().getNPC(event.getDamager());
        if (citizen == null && event.getDamager() instanceof Projectile && ((Projectile)event.getDamager()).getShooter() instanceof Entity) {
            citizen = CitizensAPI.getNPCRegistry().getNPC((Entity)((Projectile)event.getDamager()).getShooter());
        }
        if (citizen == null || !citizen.hasTrait(AssignmentTrait.class)) {
            return;
        }
        NPCTag npc = new NPCTag(citizen);
        PlayerTag player = null;
        if (event.getEntity() instanceof Player) {
            player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)((Player)event.getEntity()));
        }
        npc.action("hit", player);
        npc.action("hit on " + event.getEntityType().name(), player);
        if (event.getEntity() instanceof LivingEntity && ((LivingEntity)event.getEntity()).getHealth() - event.getFinalDamage() <= 0.0) {
            npc.action("kill", player);
            npc.action("kill of " + event.getEntityType().name(), player);
        }
    }
}

