/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import java.util.ArrayList;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDropItemEvent;

public class BlockDropsItemScriptEvent
extends BukkitScriptEvent
implements Listener {
    public LocationTag location;
    public MaterialTag material;
    public BlockDropItemEvent event;

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventArgLowerAt(1).equals("drops") || !path.eventArgsLowEqualStartingAt(3, "from", "breaking")) {
            return false;
        }
        if (!BlockDropsItemScriptEvent.couldMatchBlock(path.eventArgLowerAt(0))) {
            return false;
        }
        return BlockDropsItemScriptEvent.couldMatchItem(path.eventArgLowerAt(2));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryArgObject(0, this.material)) {
            return false;
        }
        String item = path.eventArgLowerAt(2);
        if (!item.equals("item")) {
            boolean anyMatch = false;
            for (Item itemEnt : this.event.getItems()) {
                if (!new ItemTag(itemEnt.getItemStack()).tryAdvancedMatcher(item, path.context)) continue;
                anyMatch = true;
                break;
            }
            if (!anyMatch) {
                return false;
            }
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "location": {
                return this.location;
            }
            case "material": {
                return this.material;
            }
            case "drop_entities": {
                ListTag toRet = new ListTag();
                for (Item item : this.event.getItems()) {
                    toRet.addObject(new EntityTag((Entity)item));
                }
                return toRet;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onBlockDropsItem(BlockDropItemEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.material = new MaterialTag(event.getBlockState());
        this.location = new LocationTag(event.getBlock().getLocation());
        ArrayList items = new ArrayList(event.getItems());
        for (Item item : items) {
            EntityTag.rememberEntity((Entity)item);
        }
        this.event = event;
        this.fire((Event)event);
        for (Item item : items) {
            EntityTag.forgetEntity((Entity)item);
        }
    }
}

