/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.PaperAPITools;
import com.denizenscript.denizen.utilities.ScoreboardHelper;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.ChatColor;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class TeamCommand
extends AbstractCommand {
    public TeamCommand() {
        this.setName("team");
        this.setSyntax("team (id:<scoreboard>/{main}) [name:<team>] (add:<entry>|...) (remove:<entry>|...) (prefix:<prefix>) (suffix:<suffix>) (option:<type> status:<status>) (color:<color>)");
        this.setRequiredArguments(2, 9);
        this.isProcedural = false;
        this.autoCompile();
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="id") @ArgPrefixed @ArgDefaultText(value="main") ElementTag id, @ArgName(value="name") @ArgPrefixed @ArgDefaultNull ElementTag name, @ArgName(value="add") @ArgPrefixed @ArgDefaultNull ListTag addEntities, @ArgName(value="remove") @ArgPrefixed @ArgDefaultNull ListTag removeEntities, @ArgName(value="prefix") @ArgPrefixed @ArgDefaultNull ElementTag prefix, @ArgName(value="suffix") @ArgPrefixed @ArgDefaultNull ElementTag suffix, @ArgName(value="option") @ArgPrefixed @ArgDefaultNull ElementTag option, @ArgName(value="status") @ArgPrefixed @ArgDefaultNull Team.OptionStatus status, @ArgName(value="color") @ArgPrefixed @ArgDefaultNull ChatColor color) {
        if (!NMSHandler.getVersion().isAtLeast(NMSVersion.v1_18) && name.asString().length() > 16) {
            throw new InvalidArgumentsRuntimeException("Must specify a team name between 1 and 16 characters!");
        }
        if (addEntities == null && removeEntities == null && option == null && color == null && prefix == null && suffix == null) {
            throw new InvalidArgumentsRuntimeException("Must specify something to do with the team!");
        }
        if (option == null != (status == null)) {
            throw new InvalidArgumentsRuntimeException("Option and Status arguments must go together!");
        }
        Scoreboard board = id.asString().equalsIgnoreCase("main") ? ScoreboardHelper.getMain() : (ScoreboardHelper.hasScoreboard(id.asString()) ? ScoreboardHelper.getScoreboard(id.asString()) : ScoreboardHelper.createScoreboard(id.asString()));
        Team team = board.getTeam(name.asString());
        if (team == null) {
            String low = name.asLowerString();
            team = board.getTeams().stream().filter(t -> CoreUtilities.toLowerCase(t.getName()).equals(low)).findFirst().orElse(null);
            if (team == null) {
                team = board.registerNewTeam(name.asString());
            }
        }
        if (removeEntities != null) {
            for (ObjectTag obj : removeEntities.objectForms) {
                String remove = TeamCommand.translateEntry(obj, scriptEntry.context);
                if (remove == null) continue;
                team.removeEntry(remove);
            }
        }
        if (addEntities != null) {
            for (ObjectTag obj : addEntities.objectForms) {
                String add = TeamCommand.translateEntry(obj, scriptEntry.context);
                if (add == null) continue;
                team.addEntry(add);
            }
        }
        if (option != null) {
            switch (option.asLowerString()) {
                case "friendly_fire": {
                    team.setAllowFriendlyFire(status == Team.OptionStatus.ALWAYS);
                    break;
                }
                case "see_invisible": {
                    team.setCanSeeFriendlyInvisibles(status == Team.OptionStatus.ALWAYS);
                    break;
                }
                default: {
                    if (option.matchesEnum(Team.Option.class)) {
                        team.setOption(option.asEnum(Team.Option.class), status);
                        break;
                    }
                    throw new InvalidArgumentsRuntimeException("Option doesn't exist!");
                }
            }
        }
        if (prefix != null) {
            PaperAPITools.instance.setTeamPrefix(team, prefix.asString());
        }
        if (suffix != null) {
            PaperAPITools.instance.setTeamSuffix(team, suffix.asString());
        }
        if (color != null) {
            team.setColor(color);
        }
        if (team.getEntries().isEmpty()) {
            team.unregister();
        }
    }

    public static String translateEntry(ObjectTag obj, TagContext context) {
        if (obj.shouldBeType(PlayerTag.class)) {
            return obj.asType(PlayerTag.class, context).getName();
        }
        if (obj.shouldBeType(EntityTag.class)) {
            return obj.asType(EntityTag.class, context).getUUID().toString();
        }
        return obj.toString();
    }
}

