/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import java.util.function.Consumer;

public class PlayerSteersEntityScriptEvent
extends BukkitScriptEvent {
    public static PlayerSteersEntityScriptEvent instance;
    public EntityTag entity;
    public PlayerTag player;
    public ElementTag sideways;
    public ElementTag forward;
    public ElementTag jump;
    public ElementTag dismount;
    public Consumer<Boolean> modifyCancellation;

    public PlayerSteersEntityScriptEvent() {
        instance = this;
    }

    @Override
    public void cancellationChanged() {
        this.modifyCancellation.accept(this.cancelled);
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventLower.startsWith("player steers")) {
            return false;
        }
        if (!PlayerSteersEntityScriptEvent.couldMatchEntity(path.eventArgLowerAt(2))) {
            return false;
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21)) {
            BukkitImplDeprecations.playerSteerEntityEvent.warn(path.container);
        }
        return true;
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String entityName = path.eventArgLowerAt(2);
        if (!this.entity.tryAdvancedMatcher(entityName, path.context)) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public void init() {
        NetworkInterceptHelper.enable();
        super.init();
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, this.entity.isCitizensNPC() ? this.entity.getDenizenNPC() : null);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "entity": {
                return this.entity;
            }
            case "sideways": {
                return this.sideways;
            }
            case "forward": {
                return this.forward;
            }
            case "jump": {
                return this.jump;
            }
            case "dismount": {
                return this.dismount;
            }
        }
        return super.getContext(name);
    }
}

