/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityExplosionPrimesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityTag entity;
    public ExplosionPrimeEvent event;

    public EntityExplosionPrimesScriptEvent() {
        this.registerCouldMatcher("<entity> explosion primes");
        this.registerOptionalDetermination(null, ElementTag.class, (evt, context, value) -> {
            if (value.isFloat()) {
                evt.event.setRadius(value.asFloat());
                return true;
            }
            if (value.isBoolean()) {
                BukkitImplDeprecations.explosionPrimeDetermination.warn();
                evt.event.setFire(value.asBoolean());
                return true;
            }
            return false;
        });
        this.registerOptionalDetermination("fire", ElementTag.class, (evt, context, value) -> {
            if (value.isBoolean()) {
                evt.event.setFire(value.asBoolean());
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryArgObject(0, this.entity)) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "entity" -> this.entity.getDenizenObject();
            case "radius" -> new ElementTag(this.event.getRadius());
            case "fire" -> new ElementTag(this.event.getFire());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onEntityExplosionPrimes(ExplosionPrimeEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.event = event;
        this.fire((Event)event);
    }
}

