/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.TagContext;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;

public class FurnaceStartsSmeltingScriptEvent
extends BukkitScriptEvent
implements Listener {
    public ItemTag item;
    public LocationTag location;
    public FurnaceStartSmeltEvent event;

    public FurnaceStartsSmeltingScriptEvent() {
        this.registerCouldMatcher("furnace starts smelting <item>");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!path.tryArgObject(3, this.item)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj.canBeType(DurationTag.class)) {
            this.event.setTotalCookTime(determinationObj.asType(DurationTag.class, (TagContext)this.getTagContext(path)).getTicksAsInt());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "location": {
                return this.location;
            }
            case "item": {
                return this.item;
            }
            case "recipe_id": {
                return new ElementTag(this.event.getRecipe().getKey().toString());
            }
            case "total_cook_time": {
                return new DurationTag((long)this.event.getTotalCookTime());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onFurnaceStartsSmelting(FurnaceStartSmeltEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.item = new ItemTag(event.getSource());
        this.event = event;
        this.fire((Event)event);
    }
}

