/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.item.ItemProperty;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.List;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.FloatBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class ItemArmorPose
extends ItemProperty<MapTag> {
    public static boolean describes(ItemTag item) {
        return item.getBukkitMaterial() == Material.ARMOR_STAND;
    }

    @Override
    public MapTag getPropertyValue() {
        CompoundBinaryTag entityNbt = NMSHandler.itemHelper.getEntityData(this.getItemStack());
        if (entityNbt == null) {
            return null;
        }
        CompoundBinaryTag pose = entityNbt.getCompound("Pose", null);
        if (pose == null) {
            return null;
        }
        MapTag result = new MapTag();
        ItemArmorPose.procPart(pose, "Head", "head", result);
        ItemArmorPose.procPart(pose, "Body", "body", result);
        ItemArmorPose.procPart(pose, "LeftArm", "left_arm", result);
        ItemArmorPose.procPart(pose, "RightArm", "right_arm", result);
        ItemArmorPose.procPart(pose, "LeftLeg", "left_leg", result);
        ItemArmorPose.procPart(pose, "RightLeg", "right_leg", result);
        return result;
    }

    @Override
    public void setPropertyValue(MapTag param, Mechanism mechanism) {
        CompoundBinaryTag entityNbt = NMSHandler.itemHelper.getEntityData(this.getItemStack());
        if (mechanism.hasValue()) {
            if (entityNbt == null) {
                entityNbt = CompoundBinaryTag.empty();
            }
            CompoundBinaryTag.Builder poseBuilder = CompoundBinaryTag.builder();
            ItemArmorPose.procMechKey(mechanism, poseBuilder, "Head", "head", param);
            ItemArmorPose.procMechKey(mechanism, poseBuilder, "Body", "body", param);
            ItemArmorPose.procMechKey(mechanism, poseBuilder, "LeftArm", "left_arm", param);
            ItemArmorPose.procMechKey(mechanism, poseBuilder, "RightArm", "right_arm", param);
            ItemArmorPose.procMechKey(mechanism, poseBuilder, "LeftLeg", "left_leg", param);
            ItemArmorPose.procMechKey(mechanism, poseBuilder, "RightLeg", "right_leg", param);
            CompoundBinaryTag pose = poseBuilder.build();
            entityNbt = pose.isEmpty() ? (CompoundBinaryTag)entityNbt.remove("Pose") : (CompoundBinaryTag)entityNbt.put("Pose", pose);
        } else {
            if (entityNbt == null) {
                return;
            }
            if (!entityNbt.contains("Pose", BinaryTagTypes.COMPOUND)) {
                return;
            }
            entityNbt = (CompoundBinaryTag)entityNbt.remove("Pose");
        }
        ItemStack result = NMSHandler.itemHelper.setEntityData(this.getItemStack(), entityNbt, EntityType.ARMOR_STAND);
        this.setItemStack(result);
    }

    @Override
    public String getPropertyId() {
        return "armor_pose";
    }

    public static void procPart(CompoundBinaryTag pose, String nmsName, String denizenName, MapTag result) {
        ListBinaryTag list = pose.getList(nmsName, BinaryTagTypes.FLOAT, null);
        if (list == null || list.size() != 3) {
            return;
        }
        String combined = list.getFloat(0) + "," + list.getFloat(1) + "," + list.getFloat(2);
        result.putObject(denizenName, (ObjectTag)new ElementTag(combined));
    }

    public static void register() {
        ItemArmorPose.autoRegister("armor_pose", ItemArmorPose.class, MapTag.class, false, new String[0]);
    }

    public static void procMechKey(Mechanism mech, CompoundBinaryTag.Builder poseBuilder, String nmsName, String denizenName, MapTag input) {
        ObjectTag value = input.getObject(denizenName);
        if (value == null) {
            return;
        }
        List<String> raw = CoreUtilities.split(value.toString(), ',');
        if (raw.size() != 3) {
            mech.echoError("Invalid pose piece '" + String.valueOf(value) + "'");
            return;
        }
        ListBinaryTag.Builder<FloatBinaryTag> listBuilder = ListBinaryTag.builder(BinaryTagTypes.FLOAT);
        for (int i = 0; i < 3; ++i) {
            listBuilder.add(FloatBinaryTag.floatBinaryTag(Float.parseFloat(raw.get(i))));
        }
        poseBuilder.put(nmsName, listBuilder.build());
    }
}

