/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.properties.entity.EntityProperty;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.potion.PotionType;

public class EntityPotionType
extends EntityProperty<ElementTag> {
    public static boolean describes(EntityTag entity) {
        return entity.getBukkitEntity() instanceof Arrow || entity.getBukkitEntity() instanceof AreaEffectCloud;
    }

    @Override
    public ElementTag getPropertyValue() {
        PotionType potionType;
        Entity entity = this.getEntity();
        if (entity instanceof Arrow) {
            Arrow arrow = (Arrow)entity;
            potionType = arrow.getBasePotionType();
        } else {
            potionType = this.as(AreaEffectCloud.class).getBasePotionType();
        }
        PotionType type = potionType;
        return type != null ? new ElementTag(Utilities.namespacedKeyToString(type.getKey()), true) : null;
    }

    @Override
    public void setPropertyValue(ElementTag value, Mechanism mechanism) {
        Entity entity;
        PotionType type = null;
        if (value != null) {
            if (!Utilities.requireEnumlike(mechanism, PotionType.class)) {
                return;
            }
            type = Utilities.elementToEnumlike(value, PotionType.class);
        }
        if ((entity = this.getEntity()) instanceof Arrow) {
            Arrow arrow = (Arrow)entity;
            arrow.setBasePotionType(type);
        } else {
            this.as(AreaEffectCloud.class).setBasePotionType(type);
        }
    }

    @Override
    public String getPropertyId() {
        return "potion_type";
    }

    public static void register() {
        EntityPotionType.autoRegisterNullable("potion_type", EntityPotionType.class, ElementTag.class, false, new String[0]);
    }
}

