/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.server;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.CachedServerIcon;

public class ListPingScriptEvent
extends BukkitScriptEvent
implements Listener {
    public ServerListPingEvent event;
    public static HashMap<String, CachedServerIcon> iconCache = new HashMap();

    public ListPingScriptEvent() {
        this.registerCouldMatcher("server list ping");
        this.registerDetermination(null, ListTag.class, (evt, context, list) -> {
            if (ArgumentHelper.matchesInteger(list.get(0))) {
                evt.event.setMaxPlayers(Integer.parseInt(list.get(0)));
                if (list.size() == 2) {
                    evt.setMotd(list.get(1));
                }
            } else {
                evt.setMotd(list.get(0));
            }
        });
        this.registerOptionalDetermination("max_players", ElementTag.class, (evt, context, max) -> {
            if (max.isInt()) {
                evt.event.setMaxPlayers(max.asInt());
                return true;
            }
            return false;
        });
        this.registerDetermination("motd", ElementTag.class, (evt, context, motd) -> evt.setMotd(motd.asString()));
        this.registerOptionalDetermination("icon", ElementTag.class, (evt, context, iconPath) -> {
            String iconFile = iconPath.toString();
            CachedServerIcon icon = iconCache.get(iconFile);
            if (icon != null) {
                evt.event.setServerIcon(icon);
                return true;
            }
            File file = new File(iconFile);
            if (!Utilities.canReadFile(file)) {
                Debug.echoError("Cannot read icon file '" + iconFile + "' due to security settings in Denizen/config.yml");
                return false;
            }
            try {
                icon = Bukkit.loadServerIcon((File)file);
            }
            catch (Exception ex) {
                Debug.echoError(ex);
            }
            if (icon != null) {
                iconCache.put(iconFile, icon);
                evt.event.setServerIcon(icon);
                return true;
            }
            return false;
        });
    }

    public void setMotd(String text) {
        this.event.setMotd(text);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "motd" -> new ElementTag(this.event.getMotd());
            case "max_players" -> new ElementTag(this.event.getMaxPlayers());
            case "num_players" -> new ElementTag(this.event.getNumPlayers());
            case "address" -> new ElementTag(this.event.getAddress().toString());
            case "hostname" -> {
                if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19)) {
                    yield new ElementTag(this.event.getHostname(), true);
                }
                yield null;
            }
            default -> super.getContext(name);
        };
    }

    public void syncFire(ServerListPingEvent event) {
        this.event = event;
        if (!Bukkit.isPrimaryThread()) {
            BukkitScriptEvent altEvent = (BukkitScriptEvent)this.clone();
            Future future = Bukkit.getScheduler().callSyncMethod((Plugin)Denizen.getInstance(), () -> {
                altEvent.fire((Event)event);
                return null;
            });
            try {
                future.get(5L, TimeUnit.SECONDS);
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
            return;
        }
        this.fire((Event)event);
    }

    public static class ListPingScriptEventSpigotImpl
    extends ListPingScriptEvent {
        @EventHandler
        public void onListPing(ServerListPingEvent event) {
            this.syncFire(event);
        }
    }
}

