/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.flags;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class MapTagBasedFlagTracker
extends AbstractFlagTracker {
    public static StringHolder valueString = new StringHolder("__value");
    public static StringHolder expirationString = new StringHolder("__expiration");

    public static boolean isExpired(ObjectTag expirationObj) {
        if (expirationObj == null) {
            return false;
        }
        return DenizenCore.currentTimeMillis > ((TimeTag)expirationObj).millis();
    }

    public ObjectTag getFlagValueOfType(String key, StringHolder type) {
        List<String> splitKey = CoreUtilities.split(key, '.');
        MapTag map = this.getRootMap(splitKey.get(0));
        if (map == null) {
            return null;
        }
        if (MapTagBasedFlagTracker.isExpired(map.getObject(expirationString))) {
            return null;
        }
        if (splitKey.size() == 1) {
            ObjectTag returnValue = map.getObject(type);
            if (returnValue instanceof MapTag) {
                return this.deflaggedSubMap((MapTag)returnValue);
            }
            return returnValue;
        }
        ObjectTag rootValue = map.getObject(valueString);
        if (!(rootValue instanceof MapTag)) {
            return null;
        }
        map = (MapTag)rootValue;
        String endKey = splitKey.get(splitKey.size() - 1);
        for (int i = 1; i < splitKey.size() - 1; ++i) {
            MapTag subMap = (MapTag)map.getObject(splitKey.get(i));
            if (subMap == null) {
                return null;
            }
            if (MapTagBasedFlagTracker.isExpired(subMap.getObject(expirationString))) {
                return null;
            }
            ObjectTag subValue = subMap.getObject(valueString);
            if (!(subValue instanceof MapTag)) {
                return null;
            }
            map = (MapTag)subValue;
        }
        MapTag obj = (MapTag)map.getObject(endKey);
        if (obj == null) {
            return null;
        }
        ObjectTag value = obj.getObject(type);
        if (value == null) {
            return null;
        }
        if (MapTagBasedFlagTracker.isExpired(obj.getObject(expirationString))) {
            return null;
        }
        if (value instanceof MapTag) {
            return this.deflaggedSubMap((MapTag)value);
        }
        return value;
    }

    @Override
    public ObjectTag getFlagValue(String key) {
        return this.getFlagValueOfType(key, valueString);
    }

    public MapTag deflaggedSubMap(MapTag map) {
        MapTag toReturn = new MapTag();
        for (Map.Entry<StringHolder, ObjectTag> pair : map.entrySet()) {
            MapTag subMap = (MapTag)pair.getValue();
            if (MapTagBasedFlagTracker.isExpired(subMap.getObject(expirationString))) continue;
            ObjectTag subValue = subMap.getObject(valueString);
            if (subValue instanceof MapTag) {
                subValue = this.deflaggedSubMap((MapTag)subValue);
            }
            toReturn.putObject(pair.getKey(), subValue);
        }
        return toReturn;
    }

    @Override
    public TimeTag getFlagExpirationTime(String key) {
        return (TimeTag)this.getFlagValueOfType(key, expirationString);
    }

    public boolean doClean(MapTag map) {
        if (CoreConfiguration.skipAllFlagCleanings) {
            return false;
        }
        boolean anyCleaned = false;
        ArrayList<StringHolder> toRemove = new ArrayList<StringHolder>();
        for (Map.Entry<StringHolder, ObjectTag> entry : map.entrySet()) {
            if (!(entry.getValue() instanceof MapTag)) continue;
            if (MapTagBasedFlagTracker.isExpired(((MapTag)entry.getValue()).getObject(expirationString))) {
                toRemove.add(entry.getKey());
                anyCleaned = true;
                continue;
            }
            ObjectTag subValue = ((MapTag)entry.getValue()).getObject(valueString);
            if (!(subValue instanceof MapTag)) continue;
            boolean didClean = this.doClean((MapTag)subValue);
            anyCleaned = anyCleaned || didClean;
        }
        for (StringHolder str : toRemove) {
            map.remove(str);
        }
        return anyCleaned;
    }

    public MapTag flaggifyMapTag(MapTag map) {
        MapTag toReturn = new MapTag();
        for (Map.Entry<StringHolder, ObjectTag> pair : map.entrySet()) {
            MapTag flagMap = new MapTag();
            if (pair.getValue() instanceof MapTag) {
                flagMap.putObject(valueString, (ObjectTag)this.flaggifyMapTag((MapTag)pair.getValue()));
            } else {
                flagMap.putObject(valueString, pair.getValue());
            }
            toReturn.putObject(pair.getKey(), (ObjectTag)flagMap);
        }
        return toReturn;
    }

    @Override
    public void setFlag(String key, ObjectTag value, TimeTag expiration, boolean doFlaggify) {
        MapTag rootMap;
        List<String> splitKey = CoreUtilities.split(key, '.');
        if (value == null && splitKey.size() == 1) {
            this.setRootMap(key, null);
            return;
        }
        MapTag map = rootMap = this.getRootMap(splitKey.get(0));
        String endKey = splitKey.get(splitKey.size() - 1);
        for (int i = 0; i < splitKey.size() - 1; ++i) {
            MapTag flagMap;
            MapTag mapTag = flagMap = i == 0 ? rootMap : (MapTag)map.getObject(splitKey.get(i));
            if (flagMap == null) {
                flagMap = new MapTag();
                if (i == 0) {
                    rootMap = flagMap;
                    this.setRootMap(splitKey.get(0), flagMap);
                } else {
                    map.putObject(splitKey.get(i), (ObjectTag)flagMap);
                }
            }
            ObjectTag innerMapTag = flagMap.getObject(valueString);
            flagMap.remove(expirationString);
            if (!(innerMapTag instanceof MapTag)) {
                innerMapTag = new MapTag();
                flagMap.putObject(valueString, innerMapTag);
            }
            map = (MapTag)innerMapTag;
        }
        if (value == null) {
            map.remove(endKey);
            this.setRootMap(splitKey.get(0), rootMap);
        } else {
            MapTag resultMap;
            if (value instanceof MapTag && !doFlaggify) {
                resultMap = (MapTag)value;
            } else {
                MapTag mappified;
                resultMap = new MapTag();
                if (value.shouldBeType(MapTag.class) && (mappified = value.asType(MapTag.class, CoreUtilities.noDebugContext)) != null) {
                    value = this.flaggifyMapTag(mappified);
                }
                resultMap.putObject(valueString, value);
                if (expiration != null) {
                    resultMap.putObject(expirationString, (ObjectTag)expiration);
                }
            }
            if (splitKey.size() != 1) {
                map.putObject(endKey, (ObjectTag)resultMap);
                this.setRootMap(splitKey.get(0), rootMap);
            } else {
                this.setRootMap(key, resultMap);
            }
        }
    }
}

