/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseArmorEvent;

public class BlockEquipsItemScriptEvent
extends BukkitScriptEvent
implements Listener {
    EntityTag entity;
    LocationTag location;
    BlockDispenseArmorEvent event;

    public BlockEquipsItemScriptEvent() {
        this.registerCouldMatcher("block equips <item>");
        this.registerSwitches("on");
        this.registerDetermination("item", ItemTag.class, (evt, context, item) -> evt.event.setItem(item.getItemStack()));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryArgObject(2, new ItemTag(this.event.getItem()))) {
            return false;
        }
        if (!path.tryObjectSwitch("on", this.entity)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "item" -> new ItemTag(this.event.getItem());
            case "entity" -> this.entity;
            case "location" -> this.location;
            default -> super.getContext(name);
        };
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @EventHandler
    public void onBlockEquipsItemOntoEntity(BlockDispenseArmorEvent event) {
        this.entity = new EntityTag((Entity)event.getTargetEntity());
        this.location = new LocationTag(event.getBlock().getLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

