/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.npc.traits.InvisibleTrait;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.ItemFrame;

public class EntityVisible
implements Property {
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && (((EntityTag)entity).getBukkitEntity() instanceof ArmorStand || ((EntityTag)entity).getBukkitEntity() instanceof ItemFrame || ((EntityTag)entity).isLivingEntity());
    }

    public static EntityVisible getFrom(ObjectTag entity) {
        if (!EntityVisible.describes(entity)) {
            return null;
        }
        return new EntityVisible((EntityTag)entity);
    }

    public EntityVisible(EntityTag ent) {
        this.entity = ent;
    }

    public boolean isVisible() {
        if (this.isArmorStand()) {
            return this.getArmorStand().isVisible();
        }
        if (this.isItemFrame()) {
            return this.getItemFrame().isVisible();
        }
        return !this.entity.getLivingEntity().isInvisible();
    }

    @Override
    public String getPropertyString() {
        return this.isVisible() ? null : "false";
    }

    @Override
    public String getPropertyId() {
        return "visible";
    }

    public static void register() {
        PropertyParser.registerTag(EntityVisible.class, ElementTag.class, "visible", (attribute, object) -> new ElementTag(object.isVisible()), new String[0]);
        PropertyParser.registerMechanism(EntityVisible.class, ElementTag.class, "visible", (object, mechanism, input) -> {
            if (mechanism.requireBoolean()) {
                if (object.entity.isCitizensNPC()) {
                    InvisibleTrait.setInvisible(object.entity.getLivingEntity(), object.entity.getDenizenNPC().getCitizen(), !input.asBoolean());
                } else if (object.isArmorStand()) {
                    object.getArmorStand().setVisible(input.asBoolean());
                } else if (object.isItemFrame()) {
                    object.getItemFrame().setVisible(input.asBoolean());
                } else {
                    object.entity.getLivingEntity().setInvisible(!input.asBoolean());
                }
            }
        }, new String[0]);
    }

    public boolean isArmorStand() {
        return this.entity.getBukkitEntity() instanceof ArmorStand;
    }

    public boolean isItemFrame() {
        return this.entity.getBukkitEntity() instanceof ItemFrame;
    }

    public ArmorStand getArmorStand() {
        return (ArmorStand)this.entity.getBukkitEntity();
    }

    public ItemFrame getItemFrame() {
        return (ItemFrame)this.entity.getBukkitEntity();
    }
}

