/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.Location;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Entity;

public class EntityHive
implements Property {
    public static final String[] handledTags = new String[]{"hive"};
    public static final String[] handledMechs = new String[]{"hive"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        if (!(entity instanceof EntityTag)) {
            return false;
        }
        Entity bukkitEntity = ((EntityTag)entity).getBukkitEntity();
        return bukkitEntity instanceof Bee;
    }

    public static EntityHive getFrom(ObjectTag entity) {
        if (!EntityHive.describes(entity)) {
            return null;
        }
        return new EntityHive((EntityTag)entity);
    }

    public EntityHive(EntityTag entity) {
        this.entity = entity;
    }

    public Bee getBee() {
        return (Bee)this.entity.getBukkitEntity();
    }

    @Override
    public String getPropertyString() {
        if (this.getBee().getHive() == null) {
            return null;
        }
        return new LocationTag(this.getBee().getHive()).identify();
    }

    @Override
    public String getPropertyId() {
        return "hive";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("hive")) {
            if (this.getBee().getHive() == null) {
                return null;
            }
            return new LocationTag(this.getBee().getHive()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("hive")) {
            if (mechanism.hasValue() && mechanism.requireObject(LocationTag.class)) {
                this.getBee().setHive((Location)mechanism.valueAsType(LocationTag.class));
            } else {
                this.getBee().setHive(null);
            }
        }
    }
}

