/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class PlayerStepsOnScriptEvent
extends BukkitScriptEvent
implements Listener {
    public LocationTag location;
    public PlayerMoveEvent event;
    public MaterialTag material;

    public PlayerStepsOnScriptEvent() {
        this.registerCouldMatcher("player steps on <block>");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryArgObject(3, this.material)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "location" -> this.location;
            case "previous_location" -> new LocationTag(this.event.getFrom());
            case "new_location" -> new LocationTag(this.event.getTo());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onPlayerStepsOn(PlayerMoveEvent event) {
        Location to;
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        if (event.getTo() == null) {
            return;
        }
        Location from = event.getFrom().clone().subtract(0.0, 0.05, 0.0);
        if (LocationTag.isSameBlock(from, to = event.getTo().clone().subtract(0.0, 0.05, 0.0))) {
            return;
        }
        this.location = new LocationTag(to);
        if (!Utilities.isLocationYSafe(this.location)) {
            return;
        }
        this.material = new MaterialTag(this.location.getBlock());
        this.event = event;
        this.fire((Event)event);
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.onPlayerStepsOn((PlayerMoveEvent)event);
    }
}

